% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{pool}
\alias{pool}
\title{Pool 'incidence' across groups}
\usage{
pool(x)
}
\arguments{
\item{x}{An 'incidence' object.}
}
\description{
This function pools incidence across all groups of an \code{incidence}
object. The resulting \code{\link{incidence}} object will contains counts
summed over all groups present in the input.
}
\examples{
dat <- as.integer(c(0,1,2,2,3,5,7))
group <- factor(c(1, 2, 3, 3, 3, 3, 1))
i <- incidence(dat, groups = group)
i
i$counts

## pool all groups
pool(i)
pool(i)$counts

## pool only groups 1 and 3
pool(i[,c(1,3)])
pool(i[,c(1,3)])$counts

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
\seealso{
The \code{\link{incidence}} function to generate the 'incidence'
objects.
}

