% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.from.vector.R
\name{incidence.from.vector}
\alias{incidence.from.vector}
\title{Generates an incidence matrix with given row and column marginal sums}
\usage{
incidence.from.vector(R, C, class = "matrix")
}
\arguments{
\item{R}{numeric vector: row marginal sums}

\item{C}{numeric vector: column marginal sums}

\item{class}{string: the class of the returned backbone graph, one of c("matrix", "igraph")}
}
\value{
An incidence matrix of class \code{matrix} or a bipartite graph of class {\link{igraph}}.
}
\description{
\code{incidence.from.vector} generates a random incidence matrix with given row and column sums
}
\examples{
I <- incidence.from.vector(R = c(1,1,2), C = c(1,1,2))
I <- incidence.from.vector(R = c(1,1,2), C = c(1,1,2), class = "igraph")
}
