% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize}
\alias{visualize}
\alias{visualise}
\title{Visualize statistical inference}
\usage{
visualize(
  data,
  bins = 15,
  method = "simulation",
  dens_color = "black",
  obs_stat = NULL,
  obs_stat_color = "red2",
  pvalue_fill = "pink",
  direction = NULL,
  endpoints = NULL,
  endpoints_color = "mediumaquamarine",
  ci_fill = "turquoise",
  ...
)

visualise(
  data,
  bins = 15,
  method = "simulation",
  dens_color = "black",
  obs_stat = NULL,
  obs_stat_color = "red2",
  pvalue_fill = "pink",
  direction = NULL,
  endpoints = NULL,
  endpoints_color = "mediumaquamarine",
  ci_fill = "turquoise",
  ...
)
}
\arguments{
\item{data}{The output from \code{\link[=calculate]{calculate()}}.}

\item{bins}{The number of bins in the histogram.}

\item{method}{A string giving the method to display. Options are
\code{"simulation"}, \code{"theoretical"}, or \code{"both"} with \code{"both"} corresponding to
\code{"simulation"} and \code{"theoretical"}.}

\item{dens_color}{A character or hex string specifying the color of the
theoretical density curve.}

\item{obs_stat}{A numeric value or 1x1 data frame corresponding to what the
observed statistic is. \strong{Deprecated (see Details)}.}

\item{obs_stat_color}{A character or hex string specifying the color of the
observed statistic as a vertical line on the plot. \strong{Deprecated (see
Details)}.}

\item{pvalue_fill}{A character or hex string specifying the color to shade
the p-value. In previous versions of the package this was the \code{shade_color}
argument. \strong{Deprecated (see Details)}.}

\item{direction}{A string specifying in which direction the shading should
occur. Options are \code{"less"}, \code{"greater"}, or \code{"two_sided"} for p-value. Can
also give \code{"left"}, \code{"right"}, or \code{"both"} for p-value. For confidence
intervals, use \code{"between"} and give the endpoint values in \code{endpoints}.
\strong{Deprecated (see Details)}.}

\item{endpoints}{A 2 element vector or a 1 x 2 data frame containing the
lower and upper values to be plotted. Most useful for visualizing
conference intervals. \strong{Deprecated (see Details)}.}

\item{endpoints_color}{A character or hex string specifying the color of the
observed statistic as a vertical line on the plot. \strong{Deprecated (see
Details)}.}

\item{ci_fill}{A character or hex string specifying the color to shade the
confidence interval. \strong{Deprecated (see Details)}.}

\item{...}{Other arguments passed along to \\{ggplot2\\} functions.}
}
\value{
A ggplot object showing the simulation-based distribution as a
histogram or bar graph. Also used to show the theoretical curves.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

Visualize the distribution of the simulation-based inferential statistics or
the theoretical distribution (or both!).

Learn more in \code{vignette("infer")}.
}
\details{
In order to make visualization workflow more straightforward and
explicit \code{visualize()} now only should be used to plot statistics directly.
That is why arguments not related to this task are deprecated and will be
removed in a future release of \\{infer\\}.

To add to plot information related to p-value use \code{\link[=shade_p_value]{shade_p_value()}}. To add
to plot information related to confidence interval use
\code{\link[=shade_confidence_interval]{shade_confidence_interval()}}.
}
\examples{
  
# ...and a null distribution
null_dist <- gss \%>\%
  # ...we're interested in the number of hours worked per week
  specify(response = hours) \%>\%
  # hypothesizing that the mean is 40
  hypothesize(null = "point", mu = 40) \%>\%
  # generating data points for a null distribution
  generate(reps = 10000, type = "bootstrap") \%>\%
  # finding the null distribution
  calculate(stat = "mean")
  
# we can easily plot the null distribution by piping into visualize
null_dist \%>\%
  visualize()

# we can add layers to the plot as in ggplot, as well... 
# find the point estimate---mean number of hours worked per week
point_estimate <- gss \%>\%
  specify(response = hours) \%>\%
  calculate(stat = "mean") \%>\%
  dplyr::pull()
  
# find a confidence interval around the point estimate
ci <- null_dist \%>\%
  get_confidence_interval(point_estimate = point_estimate,
                          # at the 95\% confidence level
                          level = .95,
                          # using the standard error method
                          type = "se")  
  
# display a shading of the area beyond the p-value on the plot
null_dist \%>\%
  visualize() +
  shade_p_value(obs_stat = point_estimate, direction = "two_sided")

null_dist \%>\%
  visualize() +
  shade_confidence_interval(ci)

# More in-depth explanation of how to use the infer package
vignette("infer")

}
\seealso{
\code{\link[=shade_p_value]{shade_p_value()}}, \code{\link[=shade_confidence_interval]{shade_confidence_interval()}}.
}
