% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{log_message}
\alias{log_message}
\title{Print diagnostic message}
\usage{
log_message(..., verbose = TRUE, message_type = "info", cli_model = TRUE)
}
\arguments{
\item{...}{Text to print.}

\item{verbose}{Logical value, default is \emph{\code{TRUE}}.
Whether to print the message.}

\item{message_type}{Type of message, default is \emph{\code{info}}.
Could be choose one of \emph{\code{info}}, \emph{\code{warning}}, and \emph{\code{error}}.}

\item{cli_model}{Logical value, default is \emph{\code{TRUE}}.
Whether to use the \code{cli} package to print the message.
Add because the message is printed by \code{\link[base]{message}},
the message could be suppressed by \code{\link[base]{suppressMessages}}.}
}
\description{
Print diagnostic message
}
\examples{
log_message("Hello, ", "world!")
suppressMessages(log_message("Hello, ", "world!"))
log_message("Hello, world!", verbose = FALSE)
log_message("Hello, world!", verbose = TRUE, message_type = "warning")
}
