% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifr-os-t-test.R
\name{infer_os_t_test}
\alias{infer_os_t_test}
\title{One Sample t Test}
\usage{
infer_os_t_test(
  data,
  x,
  mu = 0,
  alpha = 0.05,
  alternative = c("both", "less", "greater", "all"),
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} or \code{tibble}}

\item{x}{numeric; column in \code{data}}

\item{mu}{a number indicating the true value of the mean}

\item{alpha}{acceptable tolerance for type I error}

\item{alternative}{a character string specifying the alternative hypothesis, must be
one of "both" (default), "greater", "less" or "all". You can specify just the
initial letter}

\item{...}{additional arguments passed to or from other methods}
}
\value{
\code{infer_os_t_test} returns an object of class \code{"infer_os_t_test"}.
An object of class \code{"infer_os_t_test"} is a list containing the
following components:

\item{mu}{a number indicating the true value of the mean}
\item{n}{number of observations}
\item{df}{degrees of freedom}
\item{Mean}{observed mean of \code{x}}
\item{stddev}{standard deviation of \code{x}}
\item{std_err}{estimate of standard error}
\item{test_stat}{t statistic}
\item{confint}{confidence interval for the mean}
\item{mean_diff}{mean difference}
\item{mean_diff_l}{lower confidence limit for mean difference}
\item{mean_diff_u}{upper confidence limit for mean difference}
\item{p_l}{lower one-sided p-value}
\item{p_u}{upper one-sided p-value}
\item{p}{two sided p-value}
\item{conf}{confidence level}
\item{type}{alternative hypothesis}
\item{var_name}{name of \code{x}}
}
\description{
\code{infer_os_t_test} performs t tests on the equality of means. It tests the
hypothesis that a sample has a mean equal to a hypothesized value.
}
\section{Deprecated Function}{

\code{ttest()} has been deprecated. Instead use \code{infer_os_t_test()}.
}

\examples{
# lower tail
infer_os_t_test(hsb, write, mu = 50, alternative = 'less')

# upper tail
infer_os_t_test(hsb, write, mu = 50, alternative = 'greater')

# both tails
infer_os_t_test(hsb, write, mu = 50, alternative = 'both')

# all tails
infer_os_t_test(hsb, write, mu = 50, alternative = 'all')

}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{t.test}}
}
