% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{graph_from_data_frame}
\alias{graph_from_data_frame}
\alias{dataframe2graph}
\title{Creating igraph graphs from data frames}
\usage{
graph_from_data_frame(d, directed = TRUE, vertices = NULL)
}
\arguments{
\item{d}{A data frame containing a symbolic edge list in the first two columns.
Additional columns are considered as edge attributes.
Since version 0.7 this argument is coerced to a data frame with as.data.frame.}

\item{directed}{Logical scalar, whether or not to create a directed graph.}

\item{vertices}{A data frame with vertex metadata, or NULL.
Since version 0.7 of igraph this argument is coerced to a data frame with as.data.frame, if not NULL.}
}
\value{
An igraph graph object.
}
\description{
This function and all of its descriptions have been obtained from the igraph package.
}
\examples{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(d=MyData)
}
\seealso{
\code{\link[igraph]{graph_from_adjacency_matrix}} for a complete description on this function

Other network_reconstruction functions: 
\code{\link{graph_from_adjacency_matrix}()},
\code{\link{graph_from_incidence_matrix}()},
\code{\link{sif2igraph}()}
}
\concept{network_reconstruction functions}
\keyword{graph_from_dataframe}
