% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspect_importance.R
\name{aspect_importance_single}
\alias{aspect_importance_single}
\title{Aspects importance for single aspects}
\usage{
aspect_importance_single(x, data, predict_function = predict,
  new_observation, N = 100, sample_method = "default", n_var = 0,
  f = 2, response_variable = "")
}
\arguments{
\item{x}{a model to be explained}

\item{data}{dataset}

\item{predict_function}{predict function}

\item{new_observation}{selected observation with columns that corresponds to
variables used in the model}

\item{N}{number of rows to be sampled from data}

\item{sample_method}{sampling method in \code{\link{get_sample}}}

\item{n_var}{how many non-zero coefficients for lasso fitting, if zero than
linear regression is used}

\item{f}{frequency in in \code{\link{get_sample}}}

\item{response_variable}{name of response variable, should be provided if it is
included in data}
}
\value{
An object of the class 'aspect_importance'. Contains dataframe that
  describes aspects' importance.
}
\description{
Calculates aspect_importance for single aspects (every aspect contains only
one feature).
}
\examples{
library("DALEX")
titanic <- na.omit(titanic)
model_titanic_glm <- glm(survived == "yes" ~
                           class+gender+age+sibsp+parch+fare+embarked,
                         data = titanic, family = "binomial")

aspect_importance_single(model_titanic_glm, titanic, new_observation = titanic[1,],
                  response_variable = "survived")

}
