% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_ceteris_paribus.R
\name{print.ceteris_paribus_explainer}
\alias{print.ceteris_paribus_explainer}
\title{Prints Individual Variable Explainer Summary}
\usage{
\method{print}{ceteris_paribus_explainer}(x, ...)
}
\arguments{
\item{x}{an individual variable profile explainer produced with the \code{ceteris_paribus()} function}

\item{...}{other arguments that will be passed to \code{head()}}
}
\description{
Prints Individual Variable Explainer Summary
}
\examples{
library("DALEX")
library("ingredients")
titanic_small <- select_sample(titanic_imputed, n = 500, seed = 1313)

# build a model
model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_small,
                         family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_small[,-8],
                               y = titanic_small[,8])

cp_glm <- ceteris_paribus(explain_titanic_glm, titanic_small[1,])
cp_glm

\donttest{
library("ranger")

apartments_rf_model <- ranger(m2.price ~., data = apartments)

explainer_rf <- explain(apartments_rf_model,
                        data = apartments_test[,-1],
                        y = apartments_test[,1],
                        label = "ranger forest",
                        verbose = FALSE)

apartments_small <- select_sample(apartments_test, 10)

cp_rf <- ceteris_paribus(explainer_rf, apartments_small)
cp_rf
}
}
