% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_ceteris_paribus.R
\name{plotD3}
\alias{plotD3}
\alias{plotD3.ceteris_paribus_explainer}
\title{Plots Ceteris Paribus Profiles in D3 with r2d3 Package.}
\usage{
plotD3(x, ...)

\method{plotD3}{ceteris_paribus_explainer}(
  x,
  ...,
  size = 2,
  alpha = 1,
  color = "#46bac2",
  variable_type = "numerical",
  facet_ncol = 2,
  scale_plot = FALSE,
  variables = NULL,
  chart_title = "Ceteris Paribus Profiles",
  label_margin = 60,
  show_observations = TRUE,
  show_rugs = TRUE
)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function \code{ceteris_paribus()}}

\item{...}{other explainers that shall be plotted together}

\item{size}{a numeric. Set width of lines}

\item{alpha}{a numeric between \code{0} and \code{1}. Opacity of lines}

\item{color}{a character.  Set line color}

\item{variable_type}{a character. If "numerical" then only numerical variables will be plotted.
If "categorical" then only categorical variables will be plotted.}

\item{facet_ncol}{number of columns for the \code{\link[ggplot2]{facet_wrap}}}

\item{scale_plot}{a logical. If \code{TRUE}, the height of plot scales with window size. By default it's \code{FALSE}}

\item{variables}{if not \code{NULL} then only \code{variables} will be presented}

\item{chart_title}{a character. Set custom title}

\item{label_margin}{a numeric. Set width of label margins in \code{categorical} type}

\item{show_observations}{a logical. Adds observations layer to a plot. By default it's \code{TRUE}}

\item{show_rugs}{a logical. Adds rugs layer to a plot. By default it's \code{TRUE}}
}
\value{
a \code{r2d3} object.
}
\description{
Function \code{\link{plotD3.ceteris_paribus_explainer}} plots Individual Variable Profiles for selected observations.
It uses output from \code{\link{ceteris_paribus}} function.
Various parameters help to decide what should be plotted, profiles, aggregated profiles, points or rugs.

Find more details in \href{https://ema.drwhy.ai/ceterisParibus.html}{Ceteris Paribus Chapter}.
}
\examples{
library("DALEX")
library("ingredients")
library("ranger")

\donttest{
model_titanic_rf <- ranger(survived ~., data = titanic_imputed, probability = TRUE)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8],
                              label = "ranger forest",
                              verbose = FALSE)

selected_passangers <- select_sample(titanic_imputed, n = 10)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)

plotD3(cp_rf, variables = c("age","parch","fare","sibsp"),
     facet_ncol = 2, scale_plot = TRUE)

selected_passanger <- select_sample(titanic_imputed, n = 1)
cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passanger)

plotD3(cp_rf, variables = c("class", "embarked", "gender", "sibsp"),
     facet_ncol = 2, variable_type = "categorical", label_margin = 100, scale_plot = TRUE)
}

}
\references{
Explanatory Model Analysis. Explore, Explain, and Examine Predictive Models. \url{https://ema.drwhy.ai/}
}
