% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru.components}
\alias{bru.components}
\title{bru components}
\usage{
bru.components()
}
\description{
Similar to glm(), gam() and inla() \link{bru} uses formula objects to describe response data and latent 
(unknonw) components of the model to be fitted. However, in addition to the syntax compatible with 
\link{inla}, bru components offer addtitional functionality which facilitates modeling.
}
\details{
\link{bru} will understand formulae describing fixed effect models just like the other methods. For instance, the
formula \code{y ~ x} will fit the linear combination of an effect named \code{x} and an intercept to
the response \code{y} with respect to the likelihood family stated when calling \link{bru}. Mathematically,
the linear predictor \eqn{\eta} would be written down as 

\deqn{\eta = \beta * x + c,} 

where:

\itemize{
\item{\eqn{c} }{is the \emph{intercept}}
\item{\eqn{x }}{is a \emph{covariate}}
\item{\eqn{\beta} }{is a \emph{random variable} associated with \eqn{x} and} 
\item{\eqn{\psi = \beta * x }}{ is called the \emph{random effect} of \eqn{x}}
}

A problem that arises when using this kind of R formula is that it does not clearly relect the mathematical
formula. For instance, when providing the formula to inla, the resulting object will refer to the random
effect \eqn{\psi = \beta * x } as \code{x}. Hence, it is not clear if \code{x} refers to the covariate 
or the effect of the covariate.
}
\section{Naming random effects}{


In inla, a simple random effect model would be expressed as 

\itemize{\item{\code{formula = y ~ f(x, model = "linear")},}}

where \link{f} is the inla specific function to set up random effects of all kinds. The underlying 
predictor would again be \eqn{\eta = \beta * x + c} but the result of fitting the model would state 
\code{x} as the random effect's name. bru allows to rewrite this formula in order to explicitly state 
the name of the random effect and the name of the associated. This is achived by replacing \code{f}
with an arbitrary name that we wish to assign to the effect, e.g.

\itemize{\item{\code{components = y ~ psi(x, model = "linear")}.}}

Being able to disciminate between \eqn{x} and \eqn{\psi} is relevant because of two functionalities
bru offers. The formula parameters of both, \link{bru} and the prediction method \link{predict.bru}
are interpreted in the mathematical sense. For instance, \code{predict} may be used to analyze the
an analytical combination of the covariate \eqn{x} and the intercept using

\itemize{\item{\code{predict(fit, data.frame(x=1)), ~ exp(x + Intercept)}.}}

On the other hand, predict may be used to only look at a transformation of the random effect \eqn{\psi}

\itemize{\item{\code{predict(fit, NULL, ~ exp(psi)}.}}
}

\section{Simple covariates and the map parameter}{


It is not unusual for a random effect act on a transformation of a covariate. In other frameworks this
would mean that the transformed covariate would have to be calculated in advance and added to the 
data frame that is usually provided via the \code{data} parameter. inlabru provides the option to do
this transformation automatically. For instance, one might be interested in the effect of a covariate
\eqn{x^2}. In inla and other frameworks this would require to add a column \code{xsquared} to the
input data frame and use the formula

\itemize{\item{\code{formula = y ~ f(xsquared, model = "linear")},}}

In inlabru this can be achived using two ways of using the \code{map} parameter. 

\itemize{
\item{\code{components = y ~ psi(map = x^2, model = "linear")}}
\item{\code{components = y ~ psi(map = mySquareFun(x), model = "linear")},}
\item{\code{components = y ~ psi(map = myOtherSquareFun, model = "linear")},}

}

In the first example inlabru will interpret the map parameter as an expression to be evaluated within
the data provided. Since \eqn{x} is a knonwn covariate it will know how to calculate it. The second
example is an expression as well but it uses a function alled \code{mySquareFun}. This function is
defined by user but has wo be accessible within the work space when setting up the compoonents. 
The third example provides the function \code{myOtherSquareFun} directly and not within an expression.
In this case, inlabru will call the function using the data provided via the  \code{data} parameter. 
inlabru expects that the output of this function is a data.frame with "psi" being the name of the 
single existing column. For instance, 

\code{myOtherSquareFun = function(data) {
                            data = data[,"x", drop = FALSE] ; 
                            colnames(data) = "psi" ;
                            return(data)}}
}

\section{Spatial Covariates}{


When fitting spatial models it is common to work with covariates that depend on space, e.g. sea
surface temperature or elevation. Although it is straight forward to add this data to the input
data frame or write a covariate function like in the previous section there is an even more 
convenient way in inlabru. Spatial covariates are often stored as \code{SpatialPixelDataFrame}, 
\code{SpatialPixelDataFrame} or \code{RasterLayer} objects. These can be provided directly via 
the map parameter if the input data is a \code{SpatialPointsDataFrame}. inlabru will automatically
evaluate and/or interpolate the coariate at your data locations when using code like

\itemize{\item{\code{components = y ~ psi(mySpatialPixels, model = "linear")}.}}
}

\section{Coordinates}{


A common spatial modelling component when using inla are SPDE models. An important feature of
inlabru is that it will automatically calculate the so called A-matrix which maps SPDE 
values at the mesh vertices to values at the data locations. For this purpose, the map parameter
can be se to \code{coordinates}, which is the \code{sp} package function that extracts point 
coordinates from the SpatialPointsDataFrame that was provided as input to bru. The code for
this would look as follows:

\itemize{\item{\code{components = y ~ mySPDE(map = coordinates, model = inla.spde2.matern(...))}.}}
}

\author{
Fabian E. Bachl <\email{bachlfab@gmail.com}>
}
