% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl.R
\name{globe}
\alias{globe}
\title{Plot a globe using rgl}
\usage{
globe(R = 1, R.grid = 1.05, specular = "black", axes = FALSE,
  box = FALSE, xlab = "", ylab = "", zlab = "")
}
\arguments{
\item{R}{Radius of the globe}

\item{R.grid}{Radius of the annotation sphere.}

\item{specular}{Light color of specular effect.}

\item{axes}{If TRUE, plot x, y and z axes.}

\item{box}{If TRUE, plot a box around the globe.}

\item{xlab, ylab, zlab}{Axes labels}
}
\value{
No value, used for plotting side effect.
}
\description{
Creates a textured sphere and lon/lat coordinate annotations.
}
\details{
This funciton requires the `rgl` and `sphereplot` packages.
}
\examples{
\donttest{
if (require("rgl", quietly = TRUE) &&
    require("sphereplot", quietly = TRUE)) {

# Load pantropoical dolphin data

data("mexdolphin", package = "inlabru")

# Show the globe

globe()

# Add mesh, ship transects and dolphin sightings stored
# as inla.mesh, SpatialLines and SpatialPoints objects, respectively

glplot(mexdolphin$mesh)
glplot(mexdolphin$samplers)
glplot(mexdolphin$points)

}
}
}
\seealso{
Other inlabru RGL tools: \code{\link{glplot.SpatialLines}},
  \code{\link{glplot.SpatialPoints}},
  \code{\link{glplot.inla.mesh}}, \code{\link{glplot}}
}
\concept{inlabru RGL tools}
