% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_index}
\alias{bru_mapper_index}
\alias{ibm_invalid_output.bru_mapper_index}
\alias{ibm_jacobian.bru_mapper_index}
\title{Mapper for indexed variables}
\usage{
bru_mapper_index(n = 1L, ...)

\method{ibm_invalid_output}{bru_mapper_index}(mapper, input, state, ...)

\method{ibm_jacobian}{bru_mapper_index}(mapper, input, state, ...)
}
\arguments{
\item{n}{Size of a model for \code{bru_mapper_index}}

\item{...}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}
}
\description{
Create a an indexing mapper
}
\examples{
m <- bru_mapper_index(4)
ibm_eval(m, -2:6, 1:4)
}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()}
}
\concept{mappers}
