% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_shift}
\alias{bru_mapper_shift}
\alias{ibm_n.bru_mapper_shift}
\alias{ibm_n_output.bru_mapper_shift}
\alias{ibm_values.bru_mapper_shift}
\alias{ibm_jacobian.bru_mapper_shift}
\alias{ibm_eval.bru_mapper_shift}
\title{Mapper for element-wise shifting}
\usage{
bru_mapper_shift(mapper = NULL)

\method{ibm_n}{bru_mapper_shift}(mapper, ..., state = NULL, n_state = NULL)

\method{ibm_n_output}{bru_mapper_shift}(mapper, input, state = NULL, ..., n_state = NULL)

\method{ibm_values}{bru_mapper_shift}(mapper, ..., state = NULL, n_state = NULL)

\method{ibm_jacobian}{bru_mapper_shift}(mapper, input, state = NULL, ..., sub_lin = NULL)

\method{ibm_eval}{bru_mapper_shift}(mapper, input, state = NULL, ..., sub_lin = NULL)
}
\arguments{
\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{...}{Arguments passed on to other methods}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{n_state}{integer giving the length of the state vector for mappers
that have state dependent output size.}

\item{input}{Data input for the mapper.}

\item{sub_lin}{Internal, optional pre-computed sub-mapper information}
}
\description{
Create a standalone
shift mapper that can be used as part of a \code{bru_mapper_pipe}.
If \code{mapper} is non-null, the \code{bru_mapper_shift()} constructor
returns
\code{bru_mapper_pipe(list(mapper = mapper, shift = bru_mapper_shift()))}
}
\section{Methods (by generic)}{
\itemize{
\item \code{ibm_jacobian(bru_mapper_shift)}: \code{input} NULL values are interpreted as no shift.

}}
\examples{
m <- bru_mapper_shift()
ibm_eval2(m, c(1, 2, 1, 2), 1:4)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_fmesher}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_repeat}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_taylor}()}
}
\concept{mappers}
