% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.SpatialPolygons}
\alias{gg.SpatialPolygons}
\title{Geom for SpatialPolygons objects}
\usage{
\method{gg}{SpatialPolygons}(data, mapping = NULL, crs = NULL, ...)
}
\arguments{
\item{data}{A \code{SpatialPolygons} or \code{SpatialPolygonsDataFrame} object.}

\item{mapping}{Aesthetic mappings created by \code{aes} used to update the default
mapping.}

\item{crs}{A \code{CRS} object defining the coordinate system to project the data
to before plotting.}

\item{...}{Arguments passed on to \code{geom_sf}.
Unless specified by the user,
the argument \code{alpha = 0.2} (alpha level for polygon filling) is added.}
}
\value{
A \code{geom_sf} object.
}
\description{
Uses the \code{ggplot2::fortify()} function to turn the \code{SpatialPolygons} objects
into a \code{data.frame}. Then calls \code{geom_polygon} to plot the polygons. Requires
the \code{ggplot2} package.
}
\details{
Up to version \verb{2.10.0}, the \code{ggpolypath} package was used to ensure
proper plotting, since the \code{ggplot2::geom_polygon} function doesn't always
handle geometries with holes properly. After \verb{2.10.0}, the object is
converted to \code{sf} format and passed on to \code{\link[=gg.sf]{gg.sf()}} instead, as \code{ggplot2}
version \verb{3.4.4} deprecated the intenrally used \code{ggplot2::fortify()} method
for \code{SpatialPolygons/DataFrame} objects.
}
\examples{
\donttest{
  if (require("ggplot2", quietly = TRUE) &&
      requireNamespace("terra", quietly = TRUE) &&
      bru_safe_sp() &&
      require("sp")) {
    # Load Gorilla data

    gorillas <- inlabru::gorillas_sf

    gcov <- gorillas_sf_gcov()
    elev <- terra::as.data.frame(gcov$elevation, xy = TRUE)
    elev <- sf::as_Spatial(sf::st_as_sf(elev, coords = c("x", "y")))

    # Turn elevation covariate into SpatialGridDataFrame
    elev <- sp::SpatialPixelsDataFrame(elev, data = as.data.frame(elev))

    # Plot Gorilla elevation covariate provided as SpatialPixelsDataFrame.
    # The same syntax applies to SpatialGridDataFrame objects.

    ggplot() +
      gg(elev)

    # Add Gorilla survey boundary and nest sightings

    ggplot() +
      gg(elev) +
      gg(gorillas$boundary, alpha = 0.0, col = "red") +
      gg(gorillas$nests)

    # Load pantropical dolphin data

    mexdolphin <- inlabru::mexdolphin_sp()

    # Plot the pantropical survey boundary, ship transects and dolphin sightings

    ggplot() +
      gg(mexdolphin$ppoly) + # survey boundary as SpatialPolygon
      gg(mexdolphin$samplers) + # ship transects as SpatialLines
      gg(mexdolphin$points) # dolphin sightings as SpatialPoints

    # Change color

    ggplot() +
      gg(mexdolphin$ppoly, color = "green") + # survey boundary as SpatialPolygon
      gg(mexdolphin$samplers, color = "red") + # ship transects as SpatialLines
      gg(mexdolphin$points, color = "blue") # dolphin sightings as SpatialPoints


    # Visualize data annotations: line width by segment number

    names(mexdolphin$samplers) # 'seg' holds the segment number
    ggplot() +
      gg(mexdolphin$samplers, aes(color = seg))

    # Visualize data annotations: point size by dolphin group size

    names(mexdolphin$points) # 'size' holds the group size
    ggplot() +
      gg(mexdolphin$points, aes(size = size))
  }
}
}
\seealso{
Other geomes for spatial data: 
\code{\link{gg}()},
\code{\link{gg.SpatRaster}()},
\code{\link{gg.SpatialGridDataFrame}()},
\code{\link{gg.SpatialLines}()},
\code{\link{gg.SpatialPixels}()},
\code{\link{gg.SpatialPixelsDataFrame}()},
\code{\link{gg.SpatialPoints}()},
\code{\link{gg.sf}()}
}
\concept{geomes for spatial data}
