% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{bru_log_reset}
\alias{bru_log_reset}
\alias{bru_log_get}
\alias{bru_log_message}
\alias{bru_log}
\alias{bru_log_active}
\title{inlabru log message methods}
\usage{
bru_log_reset()

bru_log_get(pretty = FALSE)

bru_log_message(
  ...,
  domain = NULL,
  appendLF = TRUE,
  verbosity = 1,
  allow_verbose = TRUE,
  verbose = NULL,
  verbose_store = NULL
)

bru_log(txt, verbose = NULL)

bru_log_active(activation = NULL)
}
\arguments{
\item{pretty}{logical; If \code{TRUE}, return a single string with the log
messages separated and terminated by line feeds, suitable for \code{cat(...)}.
If \code{FALSE}, return the raw log as a vector of strings, suitable for
\code{cat(..., sep = "\\n")}. Default: \code{FALSE}}

\item{...}{Zero or more objects passed on to \code{\link[base:message]{base::.makeMessage()}}}

\item{domain}{Domain for translations, passed on to \code{\link[base:message]{base::.makeMessage()}}}

\item{appendLF}{logical; whether to add a newline to the message. Only
used for verbose output.}

\item{verbosity}{numeric value describing the verbosity level of the message}

\item{allow_verbose}{Whether to allow verbose output. Must be set to FALSE
until the options object has been initialised.}

\item{verbose}{logical; if \code{TRUE}, print the log message on screen with
\code{message(txt)}. Default: \code{bru_options_get("bru_verbose")}}

\item{verbose_store}{Same as \code{verbose}, but controlling what messages are
stored in the global log object. Can be controlled via the \code{bru_verbose_store}
with \code{\link[=bru_options_set]{bru_options_set()}}.}

\item{txt}{character; log message.}

\item{activation}{logical; whether to activate (\code{TRUE}) or deactivate
(\code{FALSE}) the inlabru logging system. Default: NULL, to keep the current
activation state}
}
\value{
\code{bru_log_get} RETURN_VALUE

\itemize{
\item \code{bru_log_message} OUTPUT_DESCRIPTION
}

\code{bru_log} invisibly returns the added log message.

\code{bru_log_active} returns the previous activation state
}
\description{
Resets the inlabru log object

Retrieve, add, and/or print log messages
}
\details{
\code{bru_log_reset()} clears the log contents.

\itemize{
\item \code{bru_log_message} DETAILS
}

The log message is stored if the log is active, see
\code{\link[=bru_log_active]{bru_log_active()}}
}
\examples{
\dontrun{
if (interactive()) {
  # EXAMPLE1
}
}
\dontrun{
if (interactive()) {
  # EXAMPLE1
}
}
code_runner <- function() {
  oa <- bru_log_active(TRUE)
  on.exit(bru_log_active(oa))
  bru_log("Test message")
}
bru_log_active()
code_runner()
cat(bru_log_get())
bru_log_active()
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com} and Finn Lindgren
\email{finn.lindgren@gmail.com}
}
