% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmesher_mesh.R
\name{fm_vertices}
\alias{fm_vertices}
\title{Extract vertex locations from an \code{inla.mesh}}
\usage{
fm_vertices(x, format = NULL)
}
\arguments{
\item{x}{An \code{inla.mesh} object.}

\item{format}{character; \code{"sf"}, \code{"df"}, \code{"sp"}}
}
\value{
An \code{sf}, \code{data.frame}, or \code{SpatialPointsDataFrame} object, with the vertex
coordinates, and a \code{.vertex} column with the vertex indices.
}
\description{
Extracts the vertices of an \code{inla.mesh} object.
}
\examples{
\donttest{
if (require(ggplot2, quietly = TRUE)) {
  data("mrsea", package = "inlabru")
  vrt <- fm_vertices(mrsea$mesh, format = "sp")
  ggplot() +
    gg(mrsea$mesh) +
    gg(vrt, color = "red")
}
}

}
\seealso{
\code{\link[=fm_centroids]{fm_centroids()}}
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com},
Finn Lindgren \email{finn.lindgren@gmail.com}
}
