% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{fit_inlamemi}
\alias{fit_inlamemi}
\title{Fit model for measurement error and missing data in INLA}
\usage{
fit_inlamemi(
  formula_moi,
  formula_imp = NULL,
  formula_mis = NULL,
  family_moi,
  data,
  error_type = "classical",
  error_variable = NULL,
  repeated_observations = FALSE,
  classical_error_scaling = NULL,
  prior.prec.moi = NULL,
  prior.prec.berkson = NULL,
  prior.prec.classical = NULL,
  prior.prec.imp = NULL,
  prior.beta.error = NULL,
  prior.gamma.error = NULL,
  initial.prec.moi = NULL,
  initial.prec.berkson = NULL,
  initial.prec.classical = NULL,
  initial.prec.imp = NULL,
  control.family.moi = NULL,
  control.family.berkson = NULL,
  control.family.classical = NULL,
  control.family.imp = NULL,
  control.family = NULL,
  control.predictor = NULL,
  ...
)
}
\arguments{
\item{formula_moi}{an object of class "formula", describing the main model to be fitted.}

\item{formula_imp}{an object of class "formula", describing the imputation model for the mismeasured and/or missing observations.}

\item{formula_mis}{an object of class "formula", describing the missingness model. Does not need to have a response variable, since this will always be a binary missingness indicator.}

\item{family_moi}{a string indicating the likelihood family for the model of interest (the main model).}

\item{data}{an object of class data.frame or list containing the variables in the model.}

\item{error_type}{type of error (one or more of "classical", "berkson", "missing")}

\item{error_variable}{character vector with the name(s) of the variable(s) with error.}

\item{repeated_observations}{Does the variable with measurement error and/or missingness have repeated observations? If so, set this to "TRUE". In that case, when specifying the formula, use the name of the variable without any numbers, but when specifying the data, make sure that the repeated measurements end in a number, i.e "sbp1" and "sbp2".}

\item{classical_error_scaling}{can be specified if the classical measurement error varies across observations. Must be a vector of the same length as the data.}

\item{prior.prec.moi}{a string containing the parameters for the prior for the precision of the residual term for the model of interest.}

\item{prior.prec.berkson}{a string containing the parameters for the prior for the precision of the error term for the Berkson error model.}

\item{prior.prec.classical}{a string containing the parameters for the prior for the precision of the error term for the classical error model.}

\item{prior.prec.imp}{a string containing the parameters for the precision of the latent variable x, which is the variable being described in the imputation model.}

\item{prior.beta.error}{parameters for the Gaussian prior for the coefficient of the error prone variable.}

\item{prior.gamma.error}{parameters for the Gaussian prior for the coefficient of the variable with missingness in the missingness model.}

\item{initial.prec.moi}{the initial value for the precision of the residual term for the model of interest.}

\item{initial.prec.berkson}{the initial value for the precision of the residual term for the Berkson error term.}

\item{initial.prec.classical}{the initial value for the precision of the residual term for the classical error term.}

\item{initial.prec.imp}{the initial value for the precision of the residual term for the latent variable r.}

\item{control.family.moi}{control.family component for model of interest. Can be specified here using the inla syntax instead of passing the "prior.prec..." and "initial.prec..." arguments, or in the cases when other hyperparameters are needed for the model of interest, see for instance survival models.}

\item{control.family.berkson}{control.family component Berkson model. Can be specified here using the inla syntax instead of passing the "prior.prec..." and "initial.prec..." arguments. Useful in the cases when more flexibility is needed, for instance if one wants to specify a different prior distribution than Gamma.}

\item{control.family.classical}{control.family component for classical model. Can be specified here using the inla syntax instead of passing the "prior.prec..." and "initial.prec..." arguments. Useful in the cases when more flexibility is needed, for instance if one wants to specify a different prior distribution than Gamma.}

\item{control.family.imp}{control.family component for imputation model. Can be specified here using the inla syntax instead of passing the "prior.prec..." and "initial.prec..." arguments. Useful in the cases when more flexibility is needed, for instance if one wants to specify a different prior distribution than Gamma.}

\item{control.family}{control.family for use in inla (can be provided directly instead of passing the "prior.prec...." and "initial.prec..." arguments. If this is specified, any other "control.family..." or "prior.prec..." arguments provided will be ignored.}

\item{control.predictor}{control.predictor for use in inla.}

\item{...}{other arguments to pass to `inla`.}
}
\value{
An object of class \code{inlamemi}.
}
\description{
A wrapper function around "INLA::inla()", providing the necessary structure to fit the hierarchical measurement error model that adjusts coefficient estimates to account for biases due to measurement error and missing data.
}
\examples{
\dontshow{if (requireNamespace('INLA')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Fit the model
simple_model <- fit_inlamemi(data = simple_data,
                           formula_moi = y ~ x + z,
                           formula_imp = x ~ z,
                           family_moi = "gaussian",
                           error_type = c("berkson", "classical"),
                           error_variable = "x",
                           prior.prec.moi = c(10, 9),
                           prior.prec.berkson = c(10, 9),
                           prior.prec.classical = c(10, 9),
                           prior.prec.imp = c(10, 9),
                           prior.beta.error = c(0, 1/1000),
                           initial.prec.moi = 1,
                           initial.prec.berkson = 1,
                           initial.prec.classical = 1,
                           initial.prec.imp = 1)
\dontshow{\}) # examplesIf}
}
