% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetTolColors.R
\name{GetTolColors}
\alias{GetTolColors}
\title{Color Palette for Qualitative Data}
\usage{
GetTolColors(n, alpha = 1, plot = FALSE)
}
\arguments{
\item{n}{'integer'.
Number of colors to be in the palette, the maximum is 21.}

\item{alpha}{'numeric'.
Alpha transparency, parameter values range from 0 (fully transparent) to 1 (fully opaque).
Specify as \code{NULL} to exclude the alpha channel color component.}

\item{plot}{'logical'.
Whether to display the color palette.}
}
\value{
Returns a 'character' vector of length \code{n} with elements of 7 or 9 characters,
  "#" followed by the red, blue, green, and optionally alpha values in hexadecimal.
}
\description{
This function creates a vector of \code{n} contiguous colors from color schemes by Paul Tol (2012).
}
\examples{
GetTolColors(7, plot = TRUE)

GetTolColors(21, alpha = 0.85, plot = TRUE)

}
\references{
Tol, Paul, 2012, Colour Schemes:
  SRON Technical Note, doc. no. SRON/EPS/TN/09-002, issue 2.2, 16 p.,
  accesed January 26, 2018 at \url{https://personal.sron.nl/~pault/colourschemes.pdf}.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{color}
