% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrintTable.R
\name{PrintTable}
\alias{PrintTable}
\title{Print as LaTeX Table}
\usage{
PrintTable(d, colheadings = NULL, align = NULL, digits = NULL,
  label = NULL, title = NULL, headnotes = NULL, footnotes = NULL,
  nrec = nrow(d), hline = NULL, na = "--", rm_dup = NULL,
  landscape = FALSE, ...)
}
\arguments{
\item{d}{'data.frame' or 'matrix'.
Data table to print.}

\item{colheadings}{'character' vector.
Column headings.
Use \code{\\\\\\\\} to code a line break.}

\item{align}{'character' vector.
Column alignment.
Specify \code{"l"} to left align, \code{"r"} to right align, and \code{"c"} to center align.}

\item{digits}{'integer' vector.
Number of digits to display in the corresponding columns.}

\item{label}{'character' string.
LaTeX label anchor.
Specifying this argument allows you to easily reference the table within the LaTeX document.
For example, when \code{label = "id"}, use \code{\\ref\{id\}}
to reference the table within a sentence.}

\item{title}{'character' string.
Table caption}

\item{headnotes}{'character' string.
Label placed below the table caption to provide information pertaining to the caption,
to the table as a whole, or to the column headings.}

\item{footnotes}{'character' string.
Label placed at the end of the table to provide explanations of individual entries in the table.}

\item{nrec}{'integer' vector of length 1 or 2, value is recycled as necessary.
Maximum number of records to show on the first page, and every subsequent page, respectively.}

\item{hline}{'integer' vector.
Numbers between 1 and \code{nrow(d) - 1} indicating the table rows after which
a horizontal line should appear.}

\item{na}{'character' string.
Value to be used for missing values in table entries.}

\item{rm_dup}{'integer' count.
End value of a sequence of column indexes \code{(1:rm_dup)}.
Duplicate values contained in these columns will be set equal to an empty string.
Where duplicates in a column are determined from the 'character' vector formed by
combining its content with the content from all previous columns in the table.}

\item{landscape}{'logical' flag.
If true, conforming PDF viewers will display the table in landscape orientation.
This option requires \code{\\usepackage[pdftex]{lscape}} in the LaTeX preamble.}

\item{...}{Additional arguments to be passed to the \code{\link[xtable]{print.xtable}} function.
The arguments \code{type}, \code{hline.after} and \code{add.to.row} should not be included.}
}
\value{
Invisible \code{NULL}
}
\description{
Print the LaTeX code associated with the supplied data table.
The applied output format attempts to adhere to the design recommendations
for tables in United States Geological Survey (USGS) publications.
}
\details{
Requires \code{\\usepackage{caption}}, \code{\\usepackage{booktabs}}, and
  \code{\\usepackage{makecell}} in the LaTeX preamble.
}
\examples{
d <- datasets::iris[, c(5, 1:4)]
colheadings <- c("Species of Iris",
                 "Sepal length \\\\\\\\ (cm)", "Sepal width \\\\\\\\ (cm)",
                 "Petal length \\\\\\\\ (cm)", "Petal width \\\\\\\\ (cm)")
align <- c("l", "c", "c", "c", "c")
digits <- c(0, 1, 1, 1, 1)
title <- "Measurements of sepal length and width and petal length and width,
          for three species of Iris flower."
headnotes <- "\\\\textbf{Species of Iris}: includes setosa, versicolor, and virginica.
              \\\\textbf{Abbreviations}: cm, centimeters"
levels(d[[1]]) <- sprintf("\%s\\\\footnotemark[\%d]", levels(d[[1]]), 1:3)
footnotes <- paste(sprintf("\\\\footnotemark[\%d] Common name is \%s iris.", 1:3,
                           c("Wild Flag", "Blue Flag", "Virginia")), collapse = "\\\\\\\\")
hline <- utils::tail(which(!duplicated(d[[1]])), -1) - 1L
PrintTable(d, colheadings, align, digits, title = title, headnotes = headnotes,
           footnotes = footnotes, hline = hline, nrec = c(41, 42), rm_dup = 1)

\dontrun{
sink("table-example.tex")
cat("\\\\documentclass{article}",
    "\\\\usepackage[labelsep=period,labelfont=bf]{caption}",
    "\\\\usepackage{booktabs}",
    "\\\\usepackage{makecell}",
    "\\\\usepackage[pdftex]{lscape}",
    "\\\\makeatletter",
    "\\\\setlength{\\\\@fptop}{0pt}",
    "\\\\makeatother",
    "\\\\begin{document}", sep = "\\n")
PrintTable(d, colheadings, align, digits, title = title, headnotes = headnotes,
           footnotes = footnotes, hline = hline, nrec = c(41, 42), rm_dup = 1)
cat("\\\\clearpage\\n")
PrintTable(datasets::CO2[, c(2, 3, 1, 4, 5)], digits = c(0, 0, 0, 0, 1),
           title = "Carbon dioxide uptake in grass plants.", nrec = 45, rm_dup = 3)
cat("\\\\clearpage\\n")
PrintTable(datasets::mtcars, title = "Motor trend car road tests.",
           landscape = TRUE, include.rownames = TRUE)
cat("\\\\end{document}\\n")
sink()
tools::texi2pdf("table-example.tex", clean = TRUE)  # requires TeX installation
system("open table-example.pdf")

file.remove("table-example.tex", "table-example.pdf")
}

}
\seealso{
\code{\link[xtable]{xtable}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{print}
