% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReplaceInTemplate.R
\name{ReplaceInTemplate}
\alias{ReplaceInTemplate}
\title{Replace Values in a Template Text}
\usage{
ReplaceInTemplate(text, replacement = list())
}
\arguments{
\item{text}{'character' vector.
Template text}

\item{replacement}{'list'.
Values to replace in \code{text}.}
}
\value{
Returns a 'character' vector of strings after key replacement.
}
\description{
Replace keys within special markups in a template text with specified values.
Pieces of \R code can be put into the markups of the template text,
and are evaluated during the replacement.
}
\details{
Keys are enclosed into markups of the form \code{$(KEY)} and \code{@\{CODE\}}.
}
\examples{
text <- c("Hello $(name)!", "$(a) + $(b) = @{$(a) + $(b)}",
          "pi = @{format(pi, digits = 5)}")
cat(text, sep = "\\n")
replacement <- list(name = "world", a = 1, b = 2)
cat(ReplaceInTemplate(text, replacement), sep = "\\n")

}
\references{
This code was derived from the
  \href{https://CRAN.R-project.org/package=sensitivity}{sensitivity}\code{::template.replace} function,
  accessed on Feb 6, 2015.
}
\seealso{
\code{\link{SummariseBudget}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{IO}
