% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{shave}
\alias{shave}
\title{Shave ends from DNA and amino acid sequences}
\usage{
shave(x, motif, direction = "both", cores = 1, ...)
}
\arguments{
\item{x}{an object of class \code{DNAbin} or \code{AAbin}.}

\item{motif}{a \code{DNAbin}, \code{AAbin} or \code{PHMM} object.}

\item{direction}{character string indicating
the direction of the shave. Options are "forward" (shaves everything to
the right of the motif), "backward" (shaves everything to the left of
the motif) or "both" (retains the motif region only).}

\item{cores}{integer giving the number of CPUs to parallelize the operation
over. Defaults to 1, and reverts to 1 if \code{x} is not a list.
This argument may alternatively be a 'cluster' object,
in which case it is the user's responsibility to close the socket
connection at the conclusion of the operation,
for example by running \code{parallel::stopCluster(cores)}.
The string 'autodetect' is also accepted, in which case the maximum
number of cores to use is one less than the total number of cores available.
Note that in this case there
may be a tradeoff in terms of speed depending on the number and size
of sequences to be processed, due to the extra time required to initialize
the cluster.}

\item{...}{further arguments to be passed to \code{\link[aphid]{Viterbi}}
(not including 'type').}
}
\value{
an object of class \code{DNAbin} or \code{AAbin}
  (depending on the input object).
}
\description{
This function uses the Viterbi algorithm to semi-globally align a motif to
  a DNA or AA sequence, and removes all nucleotides to the left and/or right of the
  motif.
}
\details{
This functions finds the optimal semiglobal alignment (a.k.a. "glocal"
  alignment or global alignment with free end gaps) between a
  sequence \code{"x"} and a shorter sequence \code{"motif"}, returning
  the motif region of x along with the nucleotides to the left or right
  if \code{direction} is set to \code{"reverse"} or \code{"forward"},
  respectively.
}
\examples{
  data(whales)
  motif = char2dna("AAGTGTAGCATCACTTATTGATCCAAATT")
  shave(whales, motif = motif, direction = "both")
}
\seealso{
\code{\link{virtualPCR}}.
}
\author{
Shaun Wilkinson
}
