#' InsectDisease.
#' 
#' @name InsectDisease
#' @docType package
#' @description This package provides a `R` workspace with insect disease database data already
#' present. Data are visible by using the R command ls("package:InsectDisease")`, and individual
#' data frames can be imported to your local workspace by using the command `data(NAMEOFDATA)`
#'
#'
#' Data frames can be grouped by parasite type, as `nemaref`, `nematode` and `newnema` provide information on nematode infections, as `nvpassoc` provides information on protozoans, and `viraref` and `viruses` provide details of viral infections. `pathogen` provides general taxonomic information on pathogens in the database. Citations are available in a number of places, including but not limited to `assocref`, `citation`, `nemaref`, and `viraref`.
#'
#' *When using this database, cite this reference*
#'
#' Braxton, S. M., et al. "Description and analysis of two internet-based databases of insect
#' pathogens: EDWIP and VIDIL." Journal of Invertebrate Pathology 83.3 (2003): 185-195.
#' 
#' Also, this database was originally created by the following people, to whom we are indebted:
#'
#' David W. Onstad, EDWIP Director.
#' Center for Economic Entomology, Illinois Natural History Survey
#'
#' Ellen Brewer, Research Programmer
#' Center for Economic Entomology, Illinois Natural History Survey
#' 
#' Susan Braxton, Science & Technology Librarian
#' Milner Library, Illinois State University
#'
#'






NULL
