% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_column_order.R
\name{standardize_column_order}
\alias{standardize_column_order}
\alias{standardize_column_order.parameters_model}
\title{Standardize column order}
\usage{
standardize_column_order(data, ...)

\method{standardize_column_order}{parameters_model}(data, style = c("easystats", "broom"), ...)
}
\arguments{
\item{data}{A data frame. In particular, objects from \emph{easystats}
package functions like
\code{\link[parameters:model_parameters]{parameters::model_parameters()}} or
\code{\link[effectsize:effectsize]{effectsize::effectsize()}} are accepted, but also
data frames returned by \code{broom::tidy()} are valid objects.}

\item{...}{Currently not used.}

\item{style}{Standardization can either be based on the naming conventions
from the \href{https://easystats.github.io/easystats/}{easystats-project},
or on \strong{broom}'s naming scheme.}
}
\value{
A data frame, with standardized column order.
}
\description{
Standardizes order of columns for dataframes and other objects from
\emph{easystats} and \emph{broom} ecosystem packages.
}
\examples{
# easystats conventions
df1 <- cbind.data.frame(
  CI_low      = -2.873,
  t           = 5.494,
  CI_high     = -1.088,
  p           = 0.00001,
  Parameter   = -1.980,
  CI          = 0.95,
  df          = 29.234,
  Method      = "Student's t-test"
)

standardize_column_order(df1, style = "easystats")

# broom conventions
df2 <- cbind.data.frame(
  conf.low   = -2.873,
  statistic  = 5.494,
  conf.high  = -1.088,
  p.value    = 0.00001,
  estimate   = -1.980,
  conf.level = 0.95,
  df         = 29.234,
  method     = "Student's t-test"
)

standardize_column_order(df2, style = "broom")
}
