% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_table.R
\name{format_table}
\alias{format_table}
\title{Dataframe and Tables Pretty Formatting}
\usage{
format_table(x, sep = " | ", header = "-", digits = 2,
  protect_integers = TRUE, missing = "", width = NULL)
}
\arguments{
\item{x}{A data frame.}

\item{sep}{Column separator.}

\item{header}{Header separator. Can be \code{NULL}.}

\item{digits}{Number of significant digits.}

\item{protect_integers}{Should integers be kept as integers (i.e., without decimals)?}

\item{missing}{Value by which \code{NA} values are replaced. By default, an empty string (i.e. \code{""}) is returned for \code{NA}.}

\item{width}{Minimum width of the returned string. If not \code{NULL} and \code{width} is larger than the string's length, leading whitespaces are added to the string.}
}
\value{
A data frame in character format.
}
\description{
Dataframe and Tables Pretty Formatting
}
\examples{
cat(format_table(iris))
cat(format_table(iris, sep = " ", header = "*", digits = 1))
}
