% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_algorithm.R
\name{find_algorithm}
\alias{find_algorithm}
\title{Find sampling algorithm and optimizers}
\usage{
find_algorithm(x, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}
}
\value{
A list with elements depending on the model.

For frequentist models:
\itemize{
\item \code{algorithm}, for instance \code{"OLS"} or \code{"ML"}
\item \code{optimizer}, name of optimizing function, only applies to
specific models (like \code{gam})
}

For frequentist mixed models:
\itemize{
\item \code{algorithm}, for instance \code{"REML"} or \code{"ML"}
\item \code{optimizer}, name of optimizing function
}

For Bayesian models:
\itemize{
\item \code{algorithm}, the algorithm
\item \code{chains}, number of chains
\item \code{iterations}, number of iterations per chain
\item \code{warmup}, number of warmups per chain
}
}
\description{
Returns information on the sampling or estimation algorithm
as well as optimization functions, or for Bayesian model information on
chains, iterations and warmup-samples.
}
\examples{
\dontshow{if (require("lme4", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(sleepstudy, package = "lme4")
m <- lme4::lmer(Reaction ~ Days + (1 | Subject), data = sleepstudy)
find_algorithm(m)
\dontshow{\}) # examplesIf}
\dontshow{if (require("rstanarm") && require("lme4")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
data(sleepstudy, package = "lme4")
m <- suppressWarnings(rstanarm::stan_lmer(
  Reaction ~ Days + (1 | Subject),
  data = sleepstudy,
  refresh = 0
))
find_algorithm(m)
}
\dontshow{\}) # examplesIf}
}
