% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_bf.R
\name{format_bf}
\alias{format_bf}
\title{Bayes Factor formatting}
\usage{
format_bf(
  bf,
  stars = FALSE,
  stars_only = FALSE,
  inferiority_star = "°",
  name = "BF",
  protect_ratio = FALSE,
  na_reference = NA,
  exact = FALSE
)
}
\arguments{
\item{bf}{Bayes Factor.}

\item{stars}{Add significance stars (e.g., p < .001***). For Bayes factors,
the thresholds for "significant" results are values larger than 3, 10, and 30.}

\item{stars_only}{Return only significance stars.}

\item{inferiority_star}{String, indicating the symbol that is used to
indicate inferiority, i.e. when the Bayes Factor is smaller than one third
(the thresholds are smaller than one third, 1/10 and 1/30).}

\item{name}{Name prefixing the text. Can be \code{NULL}.}

\item{protect_ratio}{Should values smaller than 1 be represented as ratios?}

\item{na_reference}{How to format missing values (\code{NA}).}

\item{exact}{Should very large or very small values be reported with a
scientific format (e.g., 4.24e5), or as truncated values (as "> 1000" and
"< 1/1000").}
}
\value{
A formatted string.
}
\description{
Bayes Factor formatting
}
\examples{
bfs <- c(0.000045, 0.033, NA, 1557, 3.54)
format_bf(bfs)
format_bf(bfs, exact = TRUE, name = NULL)
format_bf(bfs, stars = TRUE)
format_bf(bfs, protect_ratio = TRUE)
format_bf(bfs, protect_ratio = TRUE, exact = TRUE)
format_bf(bfs, na_reference = 1)
}
