% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_.R
\name{inspect_character_match}
\alias{inspect_character_match}
\title{Validate character values}
\usage{
inspect_character_match(x, allowed, case_sensitive = FALSE)
}
\arguments{
\item{x}{An arbitrary object.}

\item{allowed}{A character vector.}

\item{case_sensitive}{A non-missing logical value.}
}
\value{
\code{inspect_character_match} does not return any output. There are two possible outcomes:
\itemize{
\item The call is silent if \code{x} is a character vector of \code{\link[base]{length}} 1 whose value belongs to the set of allowed values.
\item An informative error message is thrown otherwise.
}
}
\description{
\code{inspect_character_match} checks if an object is a character vector of \code{\link[base]{length}} 1 that belongs to a set of allowed values. This can be useful to validate inputs in user-defined functions.
}
\details{
\code{inspect_character_match} conducts a series of tests to check if \code{x} is a character vector of \code{\link[base]{length}} 1 whose value belongs to the set of allowed values. Namely, \code{inspect_character_match} checks if:
\itemize{
\item \code{x} is \code{NULL} or empty.
\item \code{x} is an atomic vector of \code{\link[base]{length}} 1.
\item The \code{\link[base]{typeof}} \code{x} is character.
\item \code{x} is \code{NA} or \code{NaN}.
\item \code{x} is one of the allowed values (as specified in the \code{allowed} argument).
}

By default, the comparison of \code{x} with \code{allowed} is not case sensitive. If you only want case sensitive matches of \code{x} to \code{allowed} set \code{case_sensitive} to \code{TRUE}.
}
\examples{
# Calls that pass silently:
x1 <- "Kass"
x2 <- "kass"
inspect_character_match(x1, allowed = c("Kass", "Raftery"))
inspect_character_match(x2, allowed = c("Kass", "Raftery"))

# Calls that throw informative error messages:
y1 <- "kasss"
y2 <- "kass"
try(inspect_character_match(y1, allowed = c("Kass", "Raftery")))
try(inspect_character_match(y2, allowed = c("Kass", "Raftery"),
 case_sensitive = TRUE))
mylist <- list(NULL, character(0), c("abc", "abcd"),
 c("abc", "abc"), "ab", list("abc"), factor("abc"), NaN, NA)
try(inspect_character_match(mylist[[1]], "abc"))
try(inspect_character_match(mylist[[2]], "abc"))
try(inspect_character_match(mylist[[3]], "abc"))
try(inspect_character_match(mylist[[4]], "abc"))
try(inspect_character_match(mylist[[5]], "abc"))
try(inspect_character_match(mylist[[6]], "abc"))
try(inspect_character_match(mylist[[7]], "abc"))
try(inspect_character_match(mylist[[8]], "abc"))
try(inspect_character_match(mylist[[9]], "abc"))

}
\seealso{
\itemize{
\item \code{\link[inspector]{inspect_character}} to validate character vectors with arbitrary allowed values.
\item \code{\link[inspector]{inspect_true_or_false}} to check if an object is a non-missing logical value.
}
}
