% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_all_plot.R
\name{autoplot.univ_all}
\alias{autoplot.univ_all}
\title{Automatically create a ggplot for objects obtained from univariate_all()}
\usage{
\method{autoplot}{univ_all}(
  x,
  show_plots = c(1, 2, 3, 4),
  ncol = 1,
  background = TRUE,
  labels = TRUE,
  sort = FALSE,
  dec.mark = ",",
  color = "dodgerblue",
  color_bg = "#E7B800"
)
}
\arguments{
\item{x}{univ_all object produced by \code{univariate_all()}}

\item{show_plots}{numeric vector of plots to be shown (default is c(1,2,3,4)), there are six available plots:
 \itemize{
  \item{1. frequency (i.e. number of claims / expsore)}
  \item{2. average severity (i.e. severity / number of claims)}
  \item{3. risk premium (i.e. severity / exposure)}
  \item{4. loss ratio (i.e. severity / premium)}
  \item{5. average premium (i.e. premium / exposure)}
  \item{6. exposure}
}}

\item{ncol}{number of columns in output (default is 1)}

\item{background}{show exposure as a background histogram (default is TRUE)}

\item{labels}{show labels with the exposure (default is TRUE)}

\item{sort}{sort (or order) risk factor into descending order by exposure (default is FALSE)}

\item{dec.mark}{control the format of the decimal point, as well as the mark between intervals before the decimal point, choose either "," (default) or "."}

\item{color}{change the color of the points and line ("dodgerblue" is default)}

\item{color_bg}{change the color of the histogram ("#E7B800" is default)}
}
\value{
a ggplot2 object
}
\description{
Takes an object produced by \code{univariate_all()}, and plots the available input.
}
\examples{
library(ggplot2)
x <- univariate_all(MTPL2, x = area, severity = amount, nclaims = nclaims, exposure = exposure)
autoplot(x)
autoplot(x, show_plots = c(6,1), background = FALSE, sort = TRUE)

}
