% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidalgo_autoplot.R
\name{autoplot.Hidalgo}
\alias{autoplot.Hidalgo}
\title{Plot the output of the \code{Hidalgo} function}
\usage{
autoplot.Hidalgo(
  object,
  type = c("raw_chains", "point_estimates", "class_plot", "clustering"),
  class_plot_type = c("histogram", "density", "boxplot", "violin"),
  class = NULL,
  psm = NULL,
  clust = NULL,
  title = NULL,
  ...
)
}
\arguments{
\item{object}{object of class \code{Hidalgo}, the output of the
\code{Hidalgo()} function.}

\item{type}{character that indicates the type of plot that is requested.
It can be:
\describe{
 \item{\code{"raw_chains"}}{plot the MCMC and the ergodic means NOT corrected
 for label switching;}
 \item{\code{"point_estimates"}}{plot the posterior mean and median of the id
 for each observation, after the chains are processed for label switching;}
 \item{\code{"class_plot"}}{plot the estimated id distributions stratified by
 the groups specified in the class vector;}
 \item{\code{"clustering"}}{plot the posterior coclustering matrix. Rows and
 columns can be stratified by and external class and/or a clustering
 solution.}
 }}

\item{class_plot_type}{if \code{type} is chosen to be \code{"class_plot"},
one can plot the stratified id estimates with a \code{"density"} plot or a
\code{"histogram"}, or using \code{"boxplots"} or \code{"violin"} plots.}

\item{class}{factor variable used to stratify observations according to
their the \code{id} estimates.}

\item{psm}{posterior similarity matrix containing the posterior probability
of coclustering.}

\item{clust}{vector containing the cluster membership labels.}

\item{title}{character string used as title of the plot.}

\item{...}{other arguments passed to specific methods.}
}
\value{
a \code{\link[ggplot2]{ggplot2}} object produced by the function
according to the \code{type} chosen.
More precisely, if
\describe{
 \item{\code{method = "raw_chains"}}{The functions produces the traceplots
 of the parameters \code{d_k}, for \code{k=1...K}.
 The ergodic means for all the chains are superimposed. The \code{K} chains
 that are plotted are not post-processed.
 Ergo, they are subjected to label switching;}
 \item{\code{method = "point_estimates"}}{The function returns two
 scatterplots displaying
the posterior mean and median \code{id} for each observation, after that the
MCMC has been postprocessed to handle label switching;}
 \item{\code{method = "class_plot"}}{The function returns a plot that can be
 used to visually assess the relation between the posterior \code{id}
 estimates and an external, categorical variable. The type of plot varies
 according to the specification of \code{class_plot_type}, and it can be
 either a set of boxplots or violin plots, or a collection of overlapping
 densities or histograms;}
 \item{\code{method = "clustering"}}{The function displays the posterior
 similarity matrix, to allow the study of the clustering structure present in
 the data estimated via the mixture model. Rows and columns can be stratified
 by and external class and/or a clustering structure.}
 }
}
\description{
Use this method without the \code{.Hidalgo} suffix and after loading the
\code{ggplot2} package. It produces several plots to explore the output of
the \code{Hidalgo} model.
}
\seealso{
\code{\link{Hidalgo}}
}
