% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\name{fundamental}
\alias{fundamental}
\title{Estimate which intervals are fundamental}
\usage{
fundamental(x, conf.level = 0.9)
}
\arguments{
\item{x}{object inheriting from class \code{intRvals}, usually a result of a call to \code{\link[intRvals]{estinterval}}}

\item{conf.level}{confidence level for identifying intervals as fundamental}
}
\value{
logical atomic vector of the same length as \code{x$data}
}
\description{
Estimates which intervals in a dataset are fundamental intervals, i.e. an
interval not containing a missed arrival observation
}
\details{
This functions thus determines for each interval \code{x$data} whether it has a probabiliy > \code{conf.level} to be
a fundamental interval, given the model fit generated by \link[intRvals]{estinterval} for object \code{x}.

The fit of an \code{intRvals} object gives the decomposition of the likelihood of an interval observation
into partial likelihoods \eqn{\phi_{obs}(x,i | \mu, \sigma, p)} (see \link[intRvals]{intervalpdf}).
If the amplitude of the partial likelihood with i=0 (i.e. the likelihood component without missed observations)
is at least a proportion \code{conf.level} of the sum of all terms i=0..N,
an interval is considered to be fundamental (not containing a missed event observation).
}
