% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\name{partition}
\alias{partition}
\title{Estimate within-group variation}
\usage{
partition(x, conf.level = 0.9, alpha = 0.05, silent = F)
}
\arguments{
\item{x}{object inheriting from class \code{intRvals}}

\item{conf.level}{confidence level passed to function \link[intRvals]{fundamental}, used in selecting fundamental intervals}

\item{alpha}{significance level for differences within and between groups or subjects}

\item{silent}{logical, if \code{TRUE} print no text to console}
}
\value{
A logical atomic vector indicating which intervals are fundamental.
\describe{
  \item{\code{sigma.within}}{within-group standard deviation in interval length, estimated on fundamental intervals with repeated measures only}
  \item{\code{sigma}}{the total standard deviation in interval length, copied from \code{x$sigma}}
  \item{\code{p.within}}{p-value form a likelihood-ratio test indicating whether there is evidence for a random effect of group or subject}
  \item{\code{n.within}}{average number of intervals per group}
  \item{\code{n.total}}{total number of intervals}
  \item{\code{n.repeat}}{number of fundamental intervals with repeated measures, the size of the dataset on which \code{sigma.within} was estimated}
  \item{\code{p<alpha}}{logical. Whether there was significant evidence for a difference in within- and between-group/subject variance}
}
}
\description{
Estimate within-group variation in interval length
}
\details{
Within- and between-group variation is estimated on the subset of fundamental intervals only.

The subset of fundamental intervals is selected using \link[intRvals]{fundamental}.

We calculate \eqn{sigma.within = s_w n_{ind}/(n_{ind}+1)} with \eqn{s_w} the uncorrected sample standard deviation
of within-group centered values (obtained from subtracting the group's mean value from each observation value),
and \eqn{n_{ind}/(n_{ind}+1)} Bessel's correction with \eqn{n_{ind}} the average number of repeated measures
per group. Significance of within-group variation is determined by testing for a random effect
of group against a constant null model (van de Pol & Wright 2009),
using the R-package lme4 (Bates et al. 2015).
}
\examples{
# select the group of intervals observed on Terschelling island
dropset=goosedrop[goosedrop$site=="terschelling",]
# estimate an interval model, with separate within- and between-group variation:
dr=estinterval(data=dropset$interval,group = dropset$bout_id)
# plot the model fit:
plot(dr)
# estimate within-group variation, and its significance:
output=partition(dr)
# print within-group standard deviation:
output$sigma.within
# is the model including within-group standard deviation signicant,
# relative to a null model without separate within-group sd,
# at the specified confidence level alpha?
output$`p<alpha`  #> TRUE
}
\references{
van de Pol, M. & Wright, J. (2009). A simple method for distinguishing within- versus between-subject effects using mixed models. Animal Behaviour, 77, 753-758.

Bates, D., M\"{a}chler, M., Bolker, B.M. & Walker, S.C. (2015). Fitting linear mixed-effects models using lme4. Journal of Statistical Software, 67, 1-48.
}
