% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intcure.r
\name{basesurvfun}
\alias{basesurvfun}
\title{Estimated baseline survival function}
\usage{
basesurvfun(time, intcureobj)
}
\arguments{
\item{time}{a vector of time points at which survival probabilities will be calculated.}

\item{intcureobj}{an object from \code{intcure} function}
}
\value{
a vector of the same length as \code{time} containing the survival
probabilities at \code{time}
}
\description{
Estimate the baseline survival probabilities at specified time points
}
\details{
The estimated baseline survival function should be a continuous function and
will be smooth if the \code{basedist = "exponential"} or \code{"Weibull"}
}
\examples{
data(bmtfit)
# Estimated baseline survival at 1 year
basesurvfun(1, bmtfit)
plot(function(x)basesurvfun(x, intcureobj = bmtfit), from = 0, to = 6, type = "l")

}
\seealso{
\code{\link{intcure}}
}
\author{
Yingwei Peng
}
