% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params_check_consistent.R
\name{check_consistent}
\alias{check_consistent}
\title{Check function parameters conform to a set of rules}
\usage{
check_consistent(..., .env = rlang::caller_env())
}
\arguments{
\item{...}{a set of rules to check either as \code{x=y+z}, or \code{x>y}. Single \code{=}
assignment is checked for equality using \code{identical} otherwise the
expressions are evaluated and checked they all are true. This for
consistency with \code{\link[=resolve_missing]{resolve_missing()}} which only uses assignment, and ignores
logical expressions.}

\item{.env}{the environment to check in}
}
\value{
nothing, throws an informative error if the checks fail.
}
\description{
If the parameters of a function are given in some combination but have
an interdependency (e.g. different parametrisations of a probability
distribution) or a constraint (like \code{x>0}) this function can simultaneously
check all interrelations are satisfied and report on all the not
conformant features of the parameters.
}
\examples{
testfn = function(pos, neg, n) {
  check_consistent(pos=n-neg, neg=n-pos, n=pos+neg, n>pos, n>neg)
}

testfn(pos = 1:4, neg=4:1, n=rep(5,4))
try(testfn(pos = 1:4, neg=5:2, n=rep(5,4)))
}
\concept{parameter_checks}
