% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldbook_reshape.R
\name{fieldbook_reshape}
\alias{fieldbook_reshape}
\title{Fieldbook reshape}
\usage{
fieldbook_reshape(
  data,
  last_factor,
  sep,
  new_colname,
  from_var = NULL,
  to_var = NULL,
  exc_factors = NULL
)
}
\arguments{
\item{data}{Field book raw data.}

\item{last_factor}{The last factor in your field book.}

\item{sep}{Character that separates the last value.}

\item{new_colname}{The new name for the column created.}

\item{from_var}{The first variable in case you want to exclude several.
variables.}

\item{to_var}{The last variable in case you want to exclude several
variables.}

\item{exc_factors}{Factor to exclude during the reshape.}
}
\value{
data frame
}
\description{
Function to reshape fieldbook according a separation character
}
\details{
If you variable name is \code{variable_evaluation_rep}. The reshape function
will help to create the column \code{rep} and the new variable name will be
\code{variable_evaluation}.
}
\examples{


library(inti)
library(googlesheets4)

if (gs4_has_token()) {

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "1lslvNuebfI0YQw3KMz7clN8nIs3x8G9Da63E1em7J5o/")
# browseURL(url)
gs <- as_sheets_id(url)

(data <- gs \%>\%
    range_read("fb"))

fbrs <- fieldbook_reshape(data = data
                          , last_factor = "imbt"
                          , sep = "_"
                          , new_colname = "rep"
                          , from_var = "sch_0_1"
                          , to_var = "swc_0_1"
                          , exc_factors = "bar_code"
                          )
fbrs

}

}
