% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identification_tests.R
\name{ChenFang2019BetaRankTest}
\alias{ChenFang2019BetaRankTest}
\title{Asset Pricing Model Identification via Chen-Fang (2019) Beta Rank Test}
\usage{
ChenFang2019BetaRankTest(
  returns,
  factors,
  n_bootstrap = 500,
  target_level_kp2006_rank_test = 0.05,
  check_arguments = TRUE
)
}
\arguments{
\item{returns}{Matrix of test asset excess returns with dimensions \verb{n_observations x n_returns}.}

\item{factors}{Matrix of risk factors with dimensions \verb{n_observations x n_factors}.}

\item{n_bootstrap}{The number of bootstrap samples to use in the Chen-Fang (2019) test.
Defaults to 500 if not specified.}

\item{target_level_kp2006_rank_test}{The significance level for the Kleibergen-Paap (2006)
rank test used for initial rank estimation. If set above 0, it indicates the level for this
estimation within the Chen-Fang (2019) rank test. If set at 0 or negative, the initial rank
estimator defaults to the count of singular values exceeding \code{n_observations^(-1/4)}.
The default value is \code{0.05} to account for multiple testing.}

\item{check_arguments}{Logical flag to determine if input arguments should be checked for validity.
Default is \code{TRUE}.}
}
\value{
A list containing the Chen-Fang (2019) rank statistic and the associated p-value.
}
\description{
Tests the null hypothesis of reduced rank in the matrix of regression
loadings for test asset excess returns on risk factors using the Chen-Fang (2019)
\url{doi:10.3982/QE1139}
beta rank test. The test applies the Kleibergen-Paap (2006) \url{doi:10.1016/j.jeconom.2005.02.011}
iterative rank test
for initial rank estimation when \code{target_level_kp2006_rank_test > 0}, with an
adjustment to \code{level = target_level_kp2006_rank_test / n_factors}. When
\code{target_level_kp2006_rank_test <= 0}, the number of singular values above
\code{n_observations^(-1/4)} is used instead. It presumes that the number of factors
is less than the number of returns (\code{n_factors < n_returns}).
All the details can be found in Chen-Fang (2019)
\url{doi:10.3982/QE1139}.
}
\examples{
# import package data on 6 risk factors and 42 test asset excess returns
factors = intrinsicFRP::factors[,-1]
returns = intrinsicFRP::returns[,-1]

# compute the model identification test
hj_test = ChenFang2019BetaRankTest(returns, factors)

}
