% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profit_max_withfixedcost.R
\name{profit_max_withfixedcost}
\alias{profit_max_withfixedcost}
\title{profit_max_withfixedcost}
\usage{
profit_max_withfixedcost(
  fixed_cost,
  variable_cost,
  salesP1,
  salesP2,
  priceP1,
  priceP2
)
}
\arguments{
\item{fixed_cost, }{numeric, fixed cost for ordering and handling the SKU.}

\item{variable_cost, }{numeric, the cost of  the SKU, changing by quantity.}

\item{salesP1, }{integer, unit sales in period 1.}

\item{salesP2}{integer unit sales in period 2.}

\item{priceP1}{numeric,  average price of sku in period 1.}

\item{priceP2}{average price of sku in period 2.}
}
\value{
the elasticity ratio in unit sales, the -ve number represents the increase in sales for each decrease of unit currency.
}
\description{
maxmizing profit based on chage in price and elasticity taking into consideration fixed and variable costs.
}
\details{
This function is helpful to determine the elasticity of a product with effect to price change, the figure could be negative as the change is price is negative.
it translates as for one currency unit change in price, this much is ecpected in units in increase of sales. condition must be that Price in period one was more than price
in period 2 and sales in period two was more than sales in period 1. a proposed price is given to period 3 which is future period to maxmize profit. it is advisable that elasticity to
be calibrated by testing it on several periods. this function does not take into account advertising and campaigns,i.e external factors. yet it's a good indicator of best pricing per SKU.
}
\examples{
profit_max_withfixedcost(fixed_cost=200,variable_cost=20,salesP1=50,salesP2=100,priceP1=6,priceP2=4)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
