% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inventorymetricsCIS.R
\name{inventorymetricsCIS}
\alias{inventorymetricsCIS}
\title{inventorymetricsCIS}
\usage{
inventorymetricsCIS(
  CIS,
  demand,
  standerddeviation,
  quantity,
  leadtime,
  cost,
  holdingrate,
  na.rm = TRUE
)
}
\arguments{
\item{CIS}{numeric,cost per item short determined by management}

\item{demand}{numeric,annual demand of the SKU.}

\item{standerddeviation}{numeric, annual standard  deviation}

\item{quantity, }{numeric,quantity replinished every cycle.}

\item{leadtime, }{numeric,leadtime in weeks}

\item{cost, }{numeric cost of the SKU}

\item{holdingrate}{,numeric, holding rate per item/year}

\item{na.rm}{A logical indicating whether missing values should be removed}
}
\value{
a dataframe that contains demand leadtime,sigmadl(standard deviation in leadtime),saftey factor k determined
based on cost per itemshort,unit normal loss function,expected units to be short,cycle service level, fill rate,implied cost
per stockout event, saftey stock and suggested reorder point.
}
\description{
calculating inventory metrics based on cost per item short.
}
\details{
after cost per item short is explicitly  calculated, item fill rate, cost per stock out event and cycle service level
are implicitly calculated.
}
\note{
this is the second version of the inventorize package, all the fucntions are  without
any academic contribution from my side, the aim is to facilitate and ease much of the bookkeeping that is endured during stock analysis.
}
\examples{
inventorymetricsCIS(CIS= 90, demand= 35000,standerddeviation=9000,
quantity= 9000,leadtime=3 ,cost=90,holdingrate=0.15,na.rm =TRUE)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
