% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_check_needed_status.R
\name{check_required_status.pk}
\alias{check_required_status.pk}
\title{Check required status}
\usage{
\method{check_required_status}{pk}(obj, required_status, ...)
}
\arguments{
\item{obj}{A [pk()] object}

\item{required_status}{Integer: The required status. 1 = initialized; 2 =
pre-processed; 3 = pre-fitted; 4 = fitted.}

\item{...}{Additional arguments. Not in use.}
}
\value{
If the [pk()] object has the required status or greater, returns
  TRUE. If the [pk()] object has less than the required status, returns
  FALSE. Returned value has an attribute `msg`, containing an informative
  message as a string.
}
\description{
Check whether a [pk()] object has a particular required status level
}
\details{
This is a helper function to check whether a [pk()] object has the status
required for certain operations. For example, status 4 (fitting complete) is
required for any fit evaluation functions: [predict.pk()], [residuals.pk()],
[coef.pk()], [coef_sd.pk()], [rmse.pk()], [fold_error.pk()]
}
\author{
Caroline Ring
}
