% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iotables_download.R
\name{iotables_download}
\alias{iotables_download}
\title{Download input-output tables}
\usage{
iotables_download(
  source = "naio_10_cp1700",
  data_directory = NULL,
  force_download = TRUE
)
}
\arguments{
\item{source}{See the available list of sources above in the Description.}

\item{data_directory}{Defaults to \code{NULL}, if a valid directory, it will 
try to save the pre-processed data file here with labelling.}

\item{force_download}{Defaults to \code{TRUE}. If \code{FALSE} it will use the existing downloaded file
in the \code{data_directory} or the temporary directory, if it exists.}
}
\value{
A nested data frame. Each input-output table is in a separate 
row of the nested output, where all the metadata are in columns, and the
actual, tidy, ordered input-output table is in the data \code{data} column.
The data is saved into the actual \code{tempdir()}, too.
}
\description{
This function downloads standard input-output table files. Currently only Eurostat files are supported.
You are not likely to use this function, because 
\code{\link{iotable_get}} will
call this function if necessary and properly filter out an 
input-output table.
}
\details{
The data is downloaded in the \code{tempdir()}under the name the statistical product as an
rds file. (For example: \code{naio_10_cp1750.rds})

The temporary directory is emptied at every normal R session exit.

To save the file for further use (which is necessary in analytical work because
download times are long) set the  \code{download_directory} [see parameters]. 
The function will make a copy of the rds file in this directory.
 \itemize{
 \item{\code{naio_10_cp1700}}{ Symmetric input-output table at basic prices (product by product)}
 \item{\code{naio_10_pyp1700}}{ Symmetric input-output table at basic prices (product by product) (previous years prices)}
 \item{\code{naio_10_cp1750}}{ Symmetric input-output table at basic prices (industry by industry)}
 \item{\code{naio_10_pyp1750}}{ Symmetric input-output table at basic prices (industry by industry) (previous years prices) }
 \item{\code{naio_10_cp15}}{ Supply table at basic prices incl. transformation into purchasers' prices }
 \item{\code{naio_10_cp16}}{ Use table at purchasers' prices }
 \item{\code{naio_10_cp1610}}{ Use table at basic prices }
 \item{\code{naio_10_pyp1610}}{ Use table at basic prices (previous years prices) (naio_10_pyp1610) }
 \item{\code{naio_10_cp1620}}{ Table of trade and transport margins at basic prices}
 \item{\code{naio_10_pyp1620}}{ Table of trade and transport margins at previous years' prices}
 \item{\code{naio_10_cp1630}}{ Table of taxes less subsidies on products at basic prices}
 \item{\code{naio_10_pyp1630}}{Table of taxes less subsidies on products at previous years' prices}
 \item{\code{uk_2010_siot}}{United Kingdom Input-Output Analytical Tables data}
}
}
\examples{
\donttest{
 io_tables <- iotables_download ( source = "naio_10_cp1700" )
 }
}
\seealso{
Other iotables import functions: 
\code{\link{employment_get}()},
\code{\link{iotable_get}()},
\code{\link{iotables_metadata_get}()},
\code{\link{iotables_read_tempdir}()}
}
\concept{iotables import functions}
