% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leontieff_inverse_create.R
\name{leontieff_inverse_create}
\alias{leontieff_inverse_create}
\title{Create the inverse of a Leontieff-matrix.}
\usage{
leontieff_inverse_create(technology_coefficients_matrix, digits = NULL)
}
\arguments{
\item{technology_coefficients_matrix}{A technology coefficient matrix created
by the \code{\link{input_coefficient_matrix_create}} or 
\code{\link{output_coefficient_matrix_create}}.}

\item{digits}{An integer showing the precision of the technology matrix in 
digits. Default is \code{NULL} when no rounding is applied.}
}
\description{
The inversion takes place after the basic properties of the Leontieff matrix.
}
\examples{
tm <- input_flow_get ( 
  data_table = iotable_get(), 
  households = FALSE)
I <- leontieff_inverse_create( technology_coefficients_matrix = tm )
}
\seealso{
Other analytic object functions: 
\code{\link{input_flow_get}()},
\code{\link{leontieff_matrix_create}()}
}
\concept{analytic object functions}
