% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iota_version_1.R
\name{compute_iota1}
\alias{compute_iota1}
\title{Computes Iota and its elements in version 1}
\usage{
compute_iota1(data)
}
\arguments{
\item{data}{Data for which the elements should be estimated. Data must be
an object of type \code{data.frame} or \code{matrix} with  cases in the rows and
raters in the columns.}
}
\value{
A list with the following components
\item{alpha}{A vector containing the chance-corrected Alpha Reliabilities for
every category.}
\item{beta}{A vector containing the chance-corrected Beta Reliabilities for
every category.}
\item{iota}{A vector containing the Iota values for every category.}
\item{assignment_error_matrix}{A matrix with the conditional probabilities
for every category. The rows refer to the true categories and the columns
refer to the assigned categories. The elements on the diagonal represent the
alpha errors of that category. The other elements in each row represent the
conditioned probabilities that a coding unit is wrongly assigned to another
category.}
\item{average_iota}{A numeric value ranging between 0 and 1, representing the
Average Iota values on a categorical level. It describes the reliability of
the whole scale.}
}
\description{
Computes all elements of the Iota Reliability Concept
}
\references{
-   Berding, Florian, Elisabeth Riebenbauer, Simone Stuetz, Heike
Jahncke, Andreas Slopinski, and Karin Rebmann. 2022. Performance and
Configuration of Artificial Intelligence in Educational
Settings.Introducing a New Reliability Concept Based on Content
Analysis. Frontiers in Education.
https://doi.org/10.3389/feduc.2022.818365
}
