% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/producer.R
\docType{data}
\name{Producer}
\alias{Producer}
\title{A Class for sending signals to a source}
\description{
\strong{Methods}
  \describe{
    \item{\code{initialize(source)}}{
      Creates a Producer object linked to the \code{source}.
    }
    \item{\code{setSource(source)}}{
      Sets the \code{Source} for this producer.
    }
    \item{\code{getSource(source)}}{
      Gets the \code{Source} of this producer.
    }
    \item{\code{fire(signal, obj=NA)}}{
      Sends a signal to the source with associates object \code{obj}.
    }
    \item{\code{fireEval(expr, env)}}{
      Signals for execution of the expression \code{obj} with values from
      the environment (or list) \code{env} substituted in.
    }
    \item{\code{fireDoCall(name, param)}}{
      Signals for execution of the function whose string value is \code{name}
      with the parameters in list \code{param}.
    }
    \item{\code{fireDoCall(name, ...)}}{
      Signals for execution of the function whose string value is \code{name}
      with the parameters \code{...}.
    }
 }
}
\details{
@param obj The object to associate with the signal.
    @param signal A string signal to send.
    @param env An environment or list for substitution
    @param param A list of function parameters.
    @param expr An expression to evaluate.
    @param name the name of the function
    @param ... parameters to be passed to function
}
\keyword{datasets}
