% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipcw.R
\name{ipcw}
\alias{ipcw}
\title{Computing the stabilized IPCweights}
\usage{
ipcw(data, tstart, tstop, cens, arm, bas.cov, conf, trunc = NULL)
}
\arguments{
\item{data}{a dataframe containing the following variables}

\item{tstart}{the date of the beginning of the follow-up (in numeric format, with the first being equal at 0)}

\item{tstop}{the date of the end of the follow-up (in numeric format)}

\item{cens}{the indicator of treatment censoring (denoted by 1 at the end of the follow-up)}

\item{arm}{the randomized treatment (2-levels factor)}

\item{bas.cov}{a vector the baseline covariates}

\item{conf}{a vector of time-dependent confounders}

\item{trunc}{an optional fraction for the weights. For instance, when trunc = 0.01,
the left tail is truncated to the 1st percentile and the right tail is truncated to the 99th percentile}
}
\value{
the initial dataframe data with stabilized IPCweights as additional arguments. By default, the un-truncated stabilized weights are given. If the trunc option is not NULL then the truncated stabilized weights are also given.
}
\description{
Computing the stabilized IPCweights
}
\examples{
## Not run
# ipcw(toy.rep, tstart = tstart, tstop = tstop, cens = cens,
# arm="arm",
# bas.cov = c("age", "arm", "swtrtdt"),
# conf = c("TDconf"), trunc = 0.05)

# see ?data.ipcw for a complete example
}
\references{
Graffeo, N., Latouche, A., Le Tourneau C., Chevret, S. "An R Package for IPCW: Application to switches in clinical trials" \emph{(submitted)}
}
\seealso{
\code{\link{data.ipcw}}
}
