/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import java.awt.Color;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.BaseCanvas;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.ibase.toolkit.PPrimBase;
import org.rosuda.ibase.toolkit.PPrimRectangle;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Tools;

public class BarCanvas
extends BaseCanvas {
    static final String M_PLUS = "+";
    static final String M_SPINE = "spine";
    static final String M_SORTBYCOUNT = "sortByCount";
    static final String M_SORTBYMARKED = "sortByMarked";
    static final String M_LABELS = "labels";
    private SVar v;
    private SVar weight;
    private int[] cat_seq;
    private String[] cat_nam;
    private int cats;
    private int countMax = 0;
    private int[] count;
    private double c_max;
    private double[] cumulated;
    private double[] c_marked;
    private Object[] cols;
    private boolean hasSec;
    private int bars = 20;
    private boolean isSpine = false;
    private int dragBar;
    private int dragW;
    private int dragH;
    private MenuItem MIspine = null;
    private MenuItem MIlabels = null;
    public Color fillColorDrag = null;
    private int[] axcoordX;
    public boolean drawTicks = false;
    private int[] axcoordY;

    public BarCanvas(int n, Frame frame, SVar sVar, SMarker sMarker, SVar sVar2) {
        super(n, frame, sMarker);
        this.allowDragMove = true;
        this.borderColorSel = Color.black;
        this.changingHilitingNeedsUpdateRoot = 0;
        this.setDefaultMargins(new int[]{10, 10, 10, 20, 40, 10, 10, 10});
        this.axcoordX = new int[2];
        this.axcoordY = new int[2];
        this.v = sVar;
        this.weight = sVar2;
        this.setTitle("Barchart (" + this.v.getName() + ")");
        this.v.addDepend(this);
        this.ax = new Axis(this.v, 0, 1);
        this.ax.addDepend(this);
        this.ay = new Axis(this.v, 1, 3);
        this.ay.addDepend(this);
        this.bars = this.cats = this.v.getNumCats();
        this.pp = new PPrimRectangle[this.bars];
        this.updateObjects();
        this.createMenu(frame, true, false, false, true, new String[]{"@ESpineplot", M_SPINE, "@OSort by Count", M_SORTBYCOUNT, "!OSort by Highlighted", M_SORTBYMARKED, "@LHide Labels", M_LABELS});
        this.MIspine = EzMenu.getItem(frame, M_SPINE);
        this.MIlabels = EzMenu.getItem(frame, M_LABELS);
        this.dontPaint = false;
    }

    public BarCanvas(int n, Frame frame, SVar sVar, SMarker sMarker) {
        this(n, frame, sVar, sMarker, null);
    }

    public SVar getData(int n) {
        return n == 0 ? this.v : (n == 1 ? this.weight : null);
    }

    public void updateObjects() {
        int n;
        int n2;
        int n3;
        this.countMax = 0;
        this.c_max = 0.0;
        Object[] objectArray = this.v.getCategories();
        this.cat_nam = new String[objectArray.length + 1];
        if (this.bars != this.v.getNumCats()) {
            this.bars = this.cats = this.v.getNumCats();
            this.pp = new PPrimRectangle[this.bars];
        }
        this.cols = new Object[this.cats + 1];
        this.hasSec = false;
        for (n3 = 0; n3 < this.cats; ++n3) {
            this.cat_nam[n3] = objectArray[n3].toString();
            if (this.m == null) continue;
            this.cols[n3] = new int[this.m.getMaxMark() + 1];
        }
        this.cat_nam[n3] = "n/a";
        if (this.m != null) {
            this.cols[n3] = new int[this.m.getMaxMark() + 1];
        }
        this.count = new int[this.bars];
        for (n3 = 0; n3 < this.v.size(); ++n3) {
            n2 = this.v.getCatIndex(n3);
            if (n2 == -1) {
                n2 = this.cats;
            }
            if (this.m != null) {
                int[] nArray = (int[])this.cols[n2];
                int n4 = this.m.get(n3);
                if (n4 == -1) {
                    nArray[0] = nArray[0] + 1;
                } else if (n4 != 0 && n4 < nArray.length) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + 1;
                    this.hasSec = true;
                }
            }
            int n6 = n2;
            this.count[n6] = this.count[n6] + 1;
            if (this.count[n2] <= this.countMax) continue;
            this.countMax = this.count[n2];
        }
        this.ay.setValueRange(this.countMax);
        int n7 = this.ay.getCasePos(0);
        for (n2 = 0; n2 < this.bars; ++n2) {
            int n8;
            PPrimRectangle pPrimRectangle = new PPrimRectangle();
            this.pp[n2] = pPrimRectangle;
            n = this.ax.getCatLow(n2);
            int n9 = this.ax.getCatUp(n2);
            int n10 = n9 - n;
            if (this.isSpine) {
                n8 = Math.max(0, Math.min(3, n10 / 2 - 1));
                n9 -= n8;
                n += n8;
            } else {
                n9 -= n10 / 10;
                n += n10 / 10;
            }
            n8 = this.ay.getCasePos(this.count[n2]);
            if (this.isSpine) {
                n8 = n7 + this.ay.gLen;
            }
            if (this.orientation == 0) {
                pPrimRectangle.setBounds(n, n8, n9 - n, n7 - n8);
            } else {
                pPrimRectangle.setBounds(n7, n, n8 - n7, n9 - n);
            }
            if (this.fillColorDrag != null) {
                pPrimRectangle.fillColorDrag = this.fillColorDrag;
            }
            this.setColors(pPrimRectangle);
        }
        int[] nArray = new int[this.count.length];
        System.arraycopy(this.count, 0, nArray, 0, this.count.length);
        for (n2 = 0; n2 < this.v.size(); ++n2) {
            n = this.v.getCatIndex(n2);
            if (n < 0) continue;
            if (((PPrimRectangle)this.pp[n]).ref == null) {
                ((PPrimRectangle)this.pp[n]).ref = new int[this.count[n]];
            }
            int n11 = n;
            nArray[n11] = nArray[n11] - 1;
            ((PPrimRectangle)this.pp[n]).ref[nArray[n]] = n2;
        }
    }

    private void sortBars(boolean bl) {
        int[] nArray = new int[this.bars];
        for (int i = 0; i < this.bars; ++i) {
            nArray[i] = this.getMarked(i);
        }
        int[] nArray2 = Tools.sortIntegersIndex(bl ? nArray : this.count);
        this.ignoreNotifications = true;
        for (int i = 0; i < this.bars - 1; ++i) {
            this.ax.moveCat(nArray2[i], i);
        }
        this.ignoreNotifications = false;
        this.updateObjects();
        this.setUpdateRoot(0);
        this.repaint();
    }

    public void paintBack(PoGraSS poGraSS) {
        if (this.bars == 0) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (this.orientation == 0) {
            int bl = n2 - this.mBottom;
            this.setAxCoord(this.mLeft, bl, n - this.mLeft - this.mRight, bl);
        } else {
            this.setAxCoord(this.mLeft, this.mTop, this.mLeft, n2 - this.mTop - this.mBottom);
        }
        poGraSS.drawLine(this.axcoordX[0], this.axcoordY[0], this.axcoordX[1], this.axcoordY[1]);
        if (this.isShowLabels()) {
            boolean bl;
            this.startAddingLabels();
            boolean bl2 = bl = !Character.isDigit(this.cat_nam[0].charAt(0));
            if (this.orientation == 0) {
                int[] nArray = new int[this.pp.length];
                int[] i = new int[this.pp.length];
                for (int rectangle2 = 0; rectangle2 < this.pp.length; ++rectangle2) {
                    nArray[rectangle2] = ((PPrimRectangle)this.pp[rectangle2]).r.width;
                    i[rectangle2] = (2 * ((PPrimRectangle)this.pp[rectangle2]).r.x + nArray[rectangle2]) / 2;
                }
                this.addXLabels(poGraSS, this.ax, this.cat_nam, nArray, i, this.drawTicks, bl);
            } else {
                int[] nArray = new int[this.pp.length];
                for (int i = 0; i < this.pp.length; ++i) {
                    Rectangle rectangle2 = ((PPrimRectangle)this.pp[i]).r;
                    nArray[i] = (2 * rectangle2.y + rectangle2.height) / 2;
                }
                this.addXLabels(poGraSS, this.ax, this.cat_nam, this.mLeft, nArray, this.drawTicks, bl);
            }
            this.endAddingLabels();
        }
    }

    public void paintPost(PoGraSS poGraSS) {
        if (this.baseDrag && this.moveDrag && this.dragBar > -1) {
            ((PPrimBase)this.pp[this.dragBar]).setDragging(true);
            this.pp[this.dragBar].paint(poGraSS, this.orientation, this.m);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Common.printEvent(mouseEvent);
        if (Common.isMoveTrigger(mouseEvent)) {
            this.bars = this.cats;
            this.dragBar = -1;
            for (int i = 0; i < this.bars; ++i) {
                if (this.pp[i] == null || !this.pp[i].contains(n, n2)) continue;
                this.dragBar = i;
                this.dragW = ((PPrimRectangle)this.pp[i]).r.width;
                this.dragH = ((PPrimRectangle)this.pp[i]).r.height;
                if (this.inQuery) break;
                this.setCursor(Common.cur_hand);
                break;
            }
            this.setUpdateRoot(0);
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.baseDrag && this.moveDrag) {
            int n = this.orientation == 0 ? mouseEvent.getX() : mouseEvent.getY();
            int n2 = this.ax.getCatSeqIndex(this.dragBar);
            int n3 = this.ax.getCatByPos(n);
            int n4 = this.ax.getCatLow(n3);
            int n5 = this.ax.getCatUp(n3);
            int n6 = n - this.ax.getCatCenter(n3);
            if (Math.abs(n6) > (n5 - n4) / 4) {
                int n7 = this.ax.getCatSeqIndex(n3);
                if (n7 == -1 && n > this.ax.getCatCenter(this.ax.getCatAtSeqIndex(this.v.getNumCats() - 1))) {
                    n7 = this.v.getNumCats();
                }
                if (n6 > 0) {
                    ++n7;
                }
                if (n2 < n7) {
                    --n7;
                }
                this.ax.moveCat(this.dragBar, n7);
            } else if (this.orientation == 0) {
                this.ax.swapCats(n3, this.dragBar);
            } else {
                this.ax.swapCats(n3, this.dragBar);
            }
            this.baseDrag = false;
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    public Object run(Object object, String string) {
        int n;
        int[] nArray;
        int n2;
        super.run(object, string);
        if (M_SORTBYCOUNT.equals(string)) {
            this.sortBars(false);
        }
        if (M_SORTBYMARKED.equals(string)) {
            this.sortBars(true);
        }
        if (M_LABELS.equals(string)) {
            if (this.isShowLabels()) {
                this.MIlabels.setLabel("Show Labels");
                this.setShowLabels(false);
            } else {
                this.MIlabels.setLabel("Hide Labels");
                this.setShowLabels(true);
            }
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_SPINE.equals(string)) {
            this.setIsSpine(!this.isSpine);
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if ("setCB1".equals(string) && this.pp != null && this.pp.length > 0) {
            for (n2 = 0; n2 < this.pp.length; ++n2) {
                nArray = ((PPrimBase)this.pp[this.ax.getCatAtSeqIndex(n2)]).getCaseIDs();
                n = 0;
                if (nArray == null) continue;
                while (n < nArray.length) {
                    this.m.setSec(nArray[n++], n2 + 16);
                }
            }
            this.m.NotifyAll(new NotifyMsg(this, 4098));
        }
        if ("setCB64".equals(string) && this.pp != null && this.pp.length > 0) {
            for (n2 = 0; n2 < this.pp.length; ++n2) {
                nArray = ((PPrimBase)this.pp[this.ax.getCatAtSeqIndex(n2)]).getCaseIDs();
                n = 0;
                if (nArray == null) continue;
                while (n < nArray.length) {
                    this.m.setSec(nArray[n++], 64 + 64 * n2 / this.pp.length);
                }
            }
            this.m.NotifyAll(new NotifyMsg(this, 4098));
        }
        return null;
    }

    public String queryObject(int n) {
        int n2 = this.getMarked(n);
        String string = this.cat_nam[n] + "\n";
        boolean bl = this.isExtQuery;
        if (bl) {
            string = n2 > 0 ? string + "count: " + this.count[n] + " (" + Tools.getDisplayableValue(100.0 * (double)this.count[n] / (double)this.v.size(), 2) + "% of total)\n" + "selected: " + n2 + " (" + Tools.getDisplayableValue(100.0 * this.pp[n].getMarkedProportion(this.m, -1), 2) + "% of this cat., " + Tools.getDisplayableValue(100.0 * (double)n2 / (double)this.v.size(), 2) + "% of total, " + Tools.getDisplayableValue(100.0 * (double)n2 / (double)this.m.marked(), 2) + "% of total selection)" : string + "count: " + this.count[n] + " (" + Tools.getDisplayableValue(100.0 * (double)this.count[n] / (double)this.v.size(), 2) + "% of total)";
        } else if (this.isSpine) {
            string = n2 > 0 ? string + Tools.getDisplayableValue(100.0 * (double)this.count[n] / (double)this.v.size(), 2) + "% of total\n" + Tools.getDisplayableValue(100.0 * (double)n2 / (double)this.count[n], 2) + "% selected" : string + Tools.getDisplayableValue(100.0 * (double)this.count[n] / (double)this.v.size(), 2) + "% of total";
        } else {
            string = string + "count: " + this.count[n];
            if (n2 > 0) {
                string = string + "\nselected: " + n2 + " (" + Tools.getDisplayableValue(100.0 * (double)n2 / (double)this.count[n], 2) + "%)";
            }
        }
        return string;
    }

    public String queryPlotSpace() {
        if (this.v != null) {
            if (this.isSpine) {
                return "Barchart (" + this.v.getName() + ")\nconsists of " + this.bars + " bar(s)\n" + (this.m.marked() > 0 ? Tools.getDisplayableValue(100.0 * (double)this.m.marked() / (double)this.v.size(), 2) + "% selected" : "");
            }
            return "Barchart (" + this.v.getName() + "\nconsists of " + this.bars + " bar(s)" + (this.m.marked() > 0 ? "\n" + this.m.marked() + " selected case(s)" : "");
        }
        return null;
    }

    private int getMarked(int n) {
        return (int)((double)this.pp[n].cases() * this.pp[n].getMarkedProportion(this.m, -1) + 0.5);
    }

    public boolean adjustMargin(PoGraSS poGraSS) {
        if (this.orientation == 0) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < this.cat_nam.length; ++i) {
            int n2 = poGraSS.getWidthEstimate(this.cat_nam[i]);
            n = Math.max(n2, n);
        }
        if ((n += 4) > this.mLeft && n <= this.getBounds().width / 2) {
            this.mLeft = n;
            return true;
        }
        return false;
    }

    private void setAxCoord(int n, int n2, int n3, int n4) {
        if (n < n3) {
            this.axcoordX[0] = n;
            this.axcoordX[1] = n3;
        } else {
            this.axcoordX[0] = n3;
            this.axcoordX[1] = n;
        }
        if (n2 < n4) {
            this.axcoordY[0] = n2;
            this.axcoordY[1] = n4;
        } else {
            this.axcoordY[0] = n4;
            this.axcoordY[1] = n2;
        }
    }

    protected boolean isMouseOverAxis(int n, int n2) {
        return n >= this.axcoordX[0] - 2 && n <= this.axcoordX[1] + 2 && n2 >= this.axcoordY[0] - 2 && n2 <= this.axcoordY[1] + 2;
    }

    protected Axis getMouseOverAxis(int n, int n2) {
        if (this.isMouseOverAxis(n, n2)) {
            return this.ax;
        }
        return null;
    }

    protected String getAxisQuery(int n, int n2) {
        if (!this.isMouseOverAxis(n, n2)) {
            return null;
        }
        return "axis name: " + this.getMouseOverAxis(n, n2).getVariable().getName() + "\nbars: " + this.bars + (this.v.hasMissing() ? "\nmissings: " + this.v.getMissingCount() : "");
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (this.baseDrag && this.moveDrag && this.dragBar > -1) {
            if (this.orientation == 0) {
                ((PPrimBase)this.pp[this.dragBar]).moveX(mouseEvent.getX() - ((PPrimRectangle)this.pp[this.dragBar]).r.width / 2);
            } else {
                ((PPrimBase)this.pp[this.dragBar]).moveY(mouseEvent.getY() - ((PPrimRectangle)this.pp[this.dragBar]).r.height / 2);
            }
            this.setUpdateRoot(0);
            this.repaint();
        }
    }

    public boolean isIsSpine() {
        return this.isSpine;
    }

    public void setIsSpine(boolean bl) {
        if (bl) {
            this.ax.setType(2);
            this.MIspine.setLabel("Barchart");
        } else {
            this.ax.setType(1);
            this.MIspine.setLabel("Spineplot");
        }
        this.isSpine = bl;
    }
}

