/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.plots;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarFact;
import org.rosuda.ibase.toolkit.Axis;
import org.rosuda.ibase.toolkit.BaseCanvas;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.ibase.toolkit.PPrimBase;
import org.rosuda.ibase.toolkit.PPrimRectangle;
import org.rosuda.pograss.PoGraSS;
import org.rosuda.util.Tools;

public class HistCanvas
extends BaseCanvas {
    static final String M_PLUS = "+";
    static final String M_BINUP = "binUp";
    static final String M_BINDOWN = "binDown";
    static final String M_ANCHORLEFT = "anchorLeft";
    static final String M_ANCHORRIGHT = "anchorRight";
    static final String M_SPINE = "spine";
    protected SVar v;
    protected SVar spinovar;
    public double anchor;
    public double binw;
    private static final int DRAGMODE_NONE = 0;
    private static final int DRAGMODE_BINW = 1;
    private static final int DRAGMODE_ANCHOR = 2;
    protected int dragMode;
    protected int dragX;
    protected int dragBinwBars;
    protected int bars = 22;
    private int[] axcoordX;
    private int[] axcoordY;
    private int[] aycoordX;
    private int[] aycoordY;
    private int paintpp;
    public double maxVal = Double.NEGATIVE_INFINITY;
    private boolean isSpine;
    public double minVal = Double.POSITIVE_INFINITY;
    private boolean crosshairs = false;
    private int qx;
    private int qy;
    private Axis normalAx;
    private MenuItem MIspine = null;
    public boolean autoScaleXAxis = true;
    public boolean autoScaleYAxis = true;

    public HistCanvas(int n, Frame frame, SVar sVar, SMarker sMarker) {
        super(n, frame, sMarker);
        this.borderColorSel = Color.black;
        this.changingHilitingNeedsUpdateRoot = 0;
        this.v = sVar;
        this.setTitle("Histogram (" + this.v.getName() + ")");
        this.v.addDepend(this);
        this.ax = new Axis(sVar, 0, 0);
        this.ax.addDepend(this);
        this.normalAx = this.ax;
        this.binw = this.ax.vLen / (double)this.bars;
        this.anchor = this.v.getMin() - this.binw;
        this.ay = new Axis(sVar, 1, 3);
        this.ay.addDepend(this);
        this.createMenu(frame, true, false, false, true, new String[]{"@MSpinogram", M_SPINE, "Increase Bin Width (up)", M_BINUP, "Decrease Bin Width (down)", M_BINDOWN, "Move Anchor Left (left)", M_ANCHORLEFT, "Move Anchor Right (right)", M_ANCHORRIGHT});
        this.MIspine = EzMenu.getItem(frame, M_SPINE);
        this.setDefaultMargins(new int[]{20, 10, 10, 20, 40, 10, 10, 20, 40, 10, 20, 10, 10, 40, 10, 20});
        this.axcoordX = new int[2];
        this.axcoordY = new int[2];
        this.aycoordX = new int[2];
        this.aycoordY = new int[2];
        this.allow180 = true;
        this.allowDragZoom = false;
        this.dontPaint = false;
        try {
            Class<?> clazz = Class.forName("org.rosuda.iModels.HistMenu");
            if (clazz != null) {
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("setCanvas", this.getClass());
                if (method != null) {
                    method.invoke(obj, this);
                }
                this.pop.addSeparator();
                this.pop.add((Menu)obj);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setBoundValues() {
        if (this.pp == null) {
            return;
        }
        double d = 0.0;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.pp.length; ++i) {
            d = this.pp[i].cases();
            if (d2 < d) {
                d2 = d;
            }
            if (!(d3 > d)) continue;
            d3 = d;
        }
        this.maxVal = d2;
        this.minVal = d3;
    }

    public SVar getData(int n) {
        return n == 0 ? this.v : null;
    }

    public void updateObjects() {
        int n;
        int n2;
        this.bars = (int)((this.v.getMax() - this.anchor) / this.binw) + 1;
        if (this.dragMode != 1 && this.autoScaleXAxis) {
            this.normalAx.setValueRange(this.anchor, (double)this.bars * this.binw);
        }
        if (this.pp == null || this.pp.length != this.bars) {
            this.pp = new PPrimRectangle[this.bars];
        }
        this.paintpp = 0;
        for (n2 = 0; n2 < this.bars; ++n2) {
            this.pp[n2] = new PPrimRectangle();
            this.setColors((PPrimBase)this.pp[n2]);
        }
        int[] nArray = new int[this.bars];
        int n3 = this.v.size();
        int[] nArray2 = new int[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            Object object = this.v.at(n2);
            if (object == null) continue;
            double d = ((Number)object).doubleValue();
            n = (int)((d - this.normalAx.vBegin) / this.binw);
            nArray2[n2] = n + 1;
            if (n < 0 || n >= this.bars) continue;
            int n5 = n;
            nArray[n5] = nArray[n5] + 1;
            if (nArray[n] <= n4) continue;
            n4 = nArray[n];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n6 = nArray2[n2];
            if (n6 <= 0) continue;
            PPrimRectangle pPrimRectangle = (PPrimRectangle)this.pp[--n6];
            if (pPrimRectangle.ref == null) {
                pPrimRectangle.ref = new int[nArray[n6]];
                ++this.paintpp;
            }
            int n7 = n6;
            nArray[n7] = nArray[n7] - 1;
            pPrimRectangle.ref[nArray[n6]] = n2;
        }
        n2 = 0;
        if (this.autoScaleYAxis) {
            this.ay.setValueRange(n4);
        }
        if (this.isSpine) {
            this.createSpinovar();
            this.ax = new Axis(this.spinovar, 0, 2);
            this.setAxDefaultGeometry();
            int n8 = this.ay.getCasePos(0);
            while (n2 < this.bars) {
                PPrimRectangle pPrimRectangle = (PPrimRectangle)this.pp[n2];
                int n9 = this.ax.getCatLow(n2);
                n = this.ax.getCatUp(n2);
                int n10 = n - n9;
                int n11 = n8 + this.ay.gLen;
                if (this.orientation == 0) {
                    pPrimRectangle.setBounds(n9, n11, n - n9, n8 - n11);
                } else {
                    pPrimRectangle.setBounds(n8, n9, n11 - n8, n - n9);
                }
                ++n2;
            }
        } else {
            int n12 = this.ay.getValuePos(0.0);
            while (n2 < n3) {
                int n13 = nArray2[n2];
                if (n13 > 0) {
                    PPrimRectangle pPrimRectangle = (PPrimRectangle)this.pp[--n13];
                    n = n12;
                    int n14 = this.ax.getValuePos(this.ax.vBegin + (double)n13 * this.binw);
                    int n15 = this.ax.getValuePos(this.ax.vBegin + (double)(n13 + 1) * this.binw);
                    int n16 = this.ay.getValuePos(pPrimRectangle.ref.length);
                    if (this.orientation == 0) {
                        pPrimRectangle.setBounds(n14, n16, n15 - n14, n - n16);
                    } else if (this.orientation == 2) {
                        pPrimRectangle.setBounds(n15, n, n14 - n15, n16 - n);
                    } else if (this.orientation == 1) {
                        pPrimRectangle.setBounds(n, n14, n16 - n, n15 - n14);
                    } else {
                        pPrimRectangle.setBounds(n16, n15, n - n16, n14 - n15);
                    }
                }
                ++n2;
            }
        }
        this.setBoundValues();
    }

    public void paintBack(PoGraSS poGraSS) {
        poGraSS.setColor(this.COL_OUTLINE);
        if (this.orientation == 0) {
            this.setAxCoord(this.mLeft, this.H - this.mBottom, this.W - this.mRight, this.H - this.mBottom);
            this.setAyCoord(this.mLeft, this.H - this.mBottom, this.mLeft, this.mTop);
        } else if (this.orientation == 1) {
            this.setAxCoord(this.mLeft, this.H - this.mBottom - 100, this.mLeft, this.mTop);
            this.setAyCoord(this.mLeft, this.H - this.mBottom, this.W - this.mRight, this.H - this.mBottom);
        } else if (this.orientation == 2) {
            this.setAxCoord(this.mLeft, this.mTop, this.W - this.mRight, this.mTop);
            this.setAyCoord(this.mLeft, this.H - this.mBottom, this.mLeft, this.mTop);
        } else if (this.orientation == 3) {
            this.setAxCoord(this.W - this.mRight, this.H - this.mBottom, this.W - this.mRight, this.mTop);
            this.setAyCoord(this.mLeft, this.H - this.mBottom, this.W - this.mRight, this.H - this.mBottom);
        }
        poGraSS.drawLine(this.axcoordX[0], this.axcoordY[0], this.axcoordX[1], this.axcoordY[1]);
        poGraSS.drawLine(this.aycoordX[0], this.aycoordY[0], this.aycoordX[1], this.aycoordY[1]);
        this.startAddingLabels();
        if (!this.isSpine) {
            int n;
            int n2;
            double d;
            double d2;
            if (this.orientation == 0 || this.orientation == 2) {
                d2 = this.ay.getSensibleTickDistance(this.verticalMedDist, this.verticalMinDist);
                for (d = this.ay.getSensibleTickStart(d2); d < this.ay.vBegin + this.ay.vLen; d += d2) {
                    n2 = this.ay.getValuePos(d);
                    this.yLabels.add(this.mLeft - 8, n2 + 5, 1.0, 0.0, this.ay.getDisplayableValue(d));
                }
            } else {
                d2 = this.ay.getSensibleTickDistance(this.horizontalMedDist, this.horizontalMinDist);
                for (d = this.ay.getSensibleTickStart(d2); d < this.ay.vBegin + this.ay.vLen; d += d2) {
                    n2 = this.ay.getValuePos(d);
                    n = this.getSize().height - this.mBottom;
                    poGraSS.drawLine(n2, n, n2, n + 5);
                    this.xLabels.add(n2, n + 5, 0.5, 1.0, this.ay.getDisplayableValue(d));
                }
            }
            switch (this.orientation) {
                case 0: {
                    d2 = this.ax.getSensibleTickDistance(this.horizontalMedDist, this.horizontalMinDist);
                    for (d = this.ax.getSensibleTickStart(d2); d < this.ax.vBegin + this.ax.vLen; d += d2) {
                        n2 = this.ax.getValuePos(d);
                        n = this.getSize().height - this.mBottom;
                        poGraSS.drawLine(n2, n, n2, n + 5);
                        this.xLabels.add(n2, n + 5, 0.5, 1.0, this.ax.getDisplayableValue(d));
                    }
                    break;
                }
                case 2: {
                    d2 = this.ax.getSensibleTickDistance(this.horizontalMedDist, this.horizontalMinDist);
                    for (d = this.ax.getSensibleTickStart(d2); d < this.ax.vBegin + this.ax.vLen; d += d2) {
                        n2 = this.ax.getValuePos(d);
                        poGraSS.drawLine(n2, this.mTop - 5, n2, this.mTop);
                        this.xLabels.add(n2, this.mTop - 7, 0.5, 0.0, this.ax.getDisplayableValue(d));
                    }
                    break;
                }
                case 1: {
                    d2 = this.ax.getSensibleTickDistance(this.verticalMedDist, this.verticalMinDist);
                    for (d = this.ax.getSensibleTickStart(d2); d < this.ax.vBegin + this.ax.vLen; d += d2) {
                        n2 = this.ax.getValuePos(d);
                        poGraSS.drawLine(this.mLeft - 5, n2, this.mLeft, n2);
                        this.yLabels.add(this.mLeft - 8, n2 + 5, 1.0, 0.0, this.ax.getDisplayableValue(d));
                    }
                    break;
                }
                case 3: {
                    d2 = this.ax.getSensibleTickDistance(this.verticalMedDist, this.verticalMinDist);
                    for (d = this.ax.getSensibleTickStart(d2); d < this.ax.vBegin + this.ax.vLen; d += d2) {
                        n2 = this.ax.getValuePos(d);
                        n = this.getSize().width - this.mRight;
                        poGraSS.drawLine(n, n2, n + 5, n2);
                        this.yLabels.add(n + 8, n2 + 5, 0.0, 0.0, this.ax.getDisplayableValue(d));
                    }
                    break;
                }
            }
        }
        this.endAddingLabels();
    }

    public void paintPost(PoGraSS poGraSS) {
        if (this.crosshairs) {
            poGraSS.setColor(this.COL_OUTLINE);
            if ((this.orientation & 1) == 0) {
                if (this.qx == this.ax.clip(this.qx) && this.qy == this.ay.clip(this.qy)) {
                    poGraSS.drawLine(this.ax.gBegin, this.qy, this.ax.gBegin + this.ax.gLen, this.qy);
                    poGraSS.drawLine(this.qx, this.ay.gBegin, this.qx, this.ay.gBegin + this.ay.gLen);
                    poGraSS.drawString(this.ay.getDisplayableValue(this.ax.getValueForPos(this.qx)), this.qx + 2, this.getHeight() - this.mBottom - 2);
                    poGraSS.drawString(this.ay.getDisplayableValue(this.ay.getValueForPos(this.qy)), this.mLeft + 2, this.qy + 11);
                }
            } else if (this.qx == this.ay.clip(this.qx) && this.qy == this.ax.clip(this.qy)) {
                poGraSS.drawLine(this.qx, this.ax.gBegin, this.qx, this.ax.gBegin + this.ax.gLen);
                poGraSS.drawLine(this.ay.gBegin, this.qy, this.ay.gBegin + this.ay.gLen, this.qy);
                poGraSS.drawString(this.ax.getDisplayableValue(this.ay.getValueForPos(this.qx)), this.qx + 2, this.getHeight() - this.mBottom - 2);
                poGraSS.drawString(this.ax.getDisplayableValue(this.ax.getValueForPos(this.qy)), this.mLeft + 2, this.qy + 11);
            }
        }
        super.paintPost(poGraSS);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.orientation == 0 || this.orientation == 2) {
            if (Common.isMoveTrigger(mouseEvent) && this.orientation == 0 && n2 <= this.H - this.mBottom || this.orientation == 2 && n2 >= this.mTop) {
                this.dragBinwBars = -1;
                while (true) {
                    double d;
                    if (this.orientation != 0 || !((double)n > (d = (double)this.ax.getValuePos(this.ax.vBegin + (double)(this.dragBinwBars + 1) * this.binw)) - 3.0)) {
                        double d2;
                        if (this.orientation != 2) break;
                        d = this.ax.getValuePos(this.ax.vBegin + (double)(this.dragBinwBars + 1) * this.binw);
                        if (!((double)n < d2 + 3.0)) break;
                    }
                    if ((double)n < d + 3.0) {
                        this.dragMode = 1;
                    }
                    ++this.dragBinwBars;
                }
                if (this.dragBinwBars == 0) {
                    this.dragMode = 2;
                }
                this.dragX = n;
            } else {
                super.mousePressed(mouseEvent);
            }
        } else if (Common.isMoveTrigger(mouseEvent) && (this.orientation == 1 && n >= this.mLeft || this.orientation == 3 && n <= this.W - this.mRight)) {
            this.dragBinwBars = -1;
            while (true) {
                double d;
                if (this.orientation != 1 || !((double)n2 > (d = (double)this.ax.getValuePos(this.ax.vBegin + (double)(this.dragBinwBars + 1) * this.binw)) - 3.0)) {
                    double d3;
                    if (this.orientation != 3) break;
                    d = this.ax.getValuePos(this.ax.vBegin + (double)(this.dragBinwBars + 1) * this.binw);
                    if (!((double)n2 < d3 + 3.0)) break;
                }
                if ((double)n2 < d + 3.0) {
                    this.dragMode = 1;
                }
                ++this.dragBinwBars;
            }
            if (this.dragBinwBars == 0) {
                this.dragMode = 2;
            }
            this.dragX = n2;
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        boolean bl = this.crosshairs;
        this.crosshairs = mouseEvent.getModifiersEx() == 64;
        this.qx = mouseEvent.getX();
        this.qy = mouseEvent.getY();
        if (this.crosshairs || this.crosshairs != bl) {
            this.setUpdateRoot(3);
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragMode != 0) {
            this.dragMode = 0;
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragMode == 0) {
            super.mouseDragged(mouseEvent);
            return;
        }
        int n = this.orientation == 0 || this.orientation == 2 ? mouseEvent.getX() : mouseEvent.getY();
        if (n != this.dragX) {
            double d;
            if (this.dragMode == 1 && (d = this.ax.getValueForPos(n)) - this.ax.vBegin > 0.0) {
                this.binw = (d - this.ax.vBegin) / (double)this.dragBinwBars;
                this.updateObjects();
                this.setUpdateRoot(0);
                this.repaint();
            }
            if (this.dragMode == 2) {
                this.anchor = d = this.ax.getValueForPos(n);
                if (this.anchor > this.v.getMin()) {
                    this.anchor = this.v.getMin();
                }
                if (this.anchor < this.v.getMin() - this.binw) {
                    this.anchor = this.v.getMin() - this.binw;
                }
                this.updateObjects();
                this.setUpdateRoot(0);
                this.repaint();
            }
        }
    }

    public String queryObject(int n) {
        String string = "";
        boolean bl = this.isExtQuery;
        if (bl) {
            if (this.pp != null && this.pp[n] != null) {
                int n2 = (int)((double)this.pp[n].cases() * this.pp[n].getMarkedProportion(this.m, -1) + 0.5);
                double d = this.ax.vBegin + this.binw * (double)n;
                string = "[" + this.ax.getDisplayableValue(d) + ", " + this.ax.getDisplayableValue(d + this.binw) + ")\n";
                string = n2 > 0 ? string + "count: " + this.pp[n].cases() + " (" + Tools.getDisplayableValue(100.0 * (double)this.pp[n].cases() / (double)this.v.size(), 2) + "% of total)\n" + "selected: " + n2 + " (" + Tools.getDisplayableValue(100.0 * this.pp[n].getMarkedProportion(this.m, -1), 2) + "% of this cat., " + Tools.getDisplayableValue(100.0 * (double)n2 / (double)this.v.size(), 2) + "% of total, " + Tools.getDisplayableValue(100.0 * (double)n2 / (double)this.m.marked(), 2) + "% of total selection)" : string + "count: " + this.pp[n].cases() + " (" + Tools.getDisplayableValue(100.0 * (double)this.pp[n].cases() / (double)this.v.size(), 2) + "% of total)";
            } else {
                string = "N/A";
            }
        } else if (this.pp != null && this.pp[n] != null) {
            int n3 = (int)((double)this.pp[n].cases() * this.pp[n].getMarkedProportion(this.m, -1) + 0.5);
            string = this.getIntervalForBox(n) + "\n" + "count: " + this.pp[n].cases() + (n3 > 0 ? "\nselected: " + n3 : "");
        } else {
            string = "N/A";
        }
        return string;
    }

    public String queryPlotSpace() {
        if (this.v == null) {
            return null;
        }
        return "Histogram\nmin: " + this.minVal + "\nmax: " + this.maxVal + "\nconsist of " + this.paintpp + " bins" + (this.m.marked() > 0 ? "\n" + this.m.marked() + " selected case(s)" : "");
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.run(this, M_BINUP);
                break;
            }
            case 40: {
                this.run(this, M_BINDOWN);
                break;
            }
            case 37: {
                this.run(this, M_ANCHORLEFT);
                break;
            }
            case 39: {
                this.run(this, M_ANCHORRIGHT);
            }
        }
    }

    public Object run(Object object, String string) {
        int n;
        int[] nArray;
        double d;
        super.run(object, string);
        if (M_BINUP.equals(string)) {
            this.binw *= 1.1;
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_BINDOWN.equals(string) && Math.abs((d = Math.min(this.binw / 1.1, this.binw)) - this.binw) > 1.0E-5) {
            this.binw = d;
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_ANCHORRIGHT.equals(string)) {
            this.anchor = Math.min(this.anchor + 0.1 * this.binw, this.v.getMin());
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_ANCHORLEFT.equals(string)) {
            this.anchor = Math.max(this.anchor - 0.1 * this.binw, this.v.getMin() - this.binw);
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if (M_SPINE.equals(string)) {
            this.setIsSpine(!this.isSpine);
            this.updateObjects();
            this.setUpdateRoot(0);
            this.repaint();
        }
        if ("setCB1".equals(string) && this.pp != null && this.pp.length > 0) {
            for (int i = 0; i < this.pp.length; ++i) {
                nArray = ((PPrimBase)this.pp[i]).getCaseIDs();
                n = 0;
                if (nArray == null) continue;
                while (n < nArray.length) {
                    this.m.setSec(nArray[n++], i + 16);
                }
            }
            this.m.NotifyAll(new NotifyMsg(this, 4098));
        }
        if ("setCB64".equals(string) && this.pp != null && this.pp.length > 0) {
            for (int i = 0; i < this.pp.length; ++i) {
                nArray = ((PPrimBase)this.pp[i]).getCaseIDs();
                n = 0;
                if (nArray == null) continue;
                while (n < nArray.length) {
                    this.m.setSec(nArray[n++], 64 + 64 * i / this.pp.length);
                }
            }
            this.m.NotifyAll(new NotifyMsg(this, 4098));
        }
        return null;
    }

    private void setAxCoord(int n, int n2, int n3, int n4) {
        if (n < n3) {
            this.axcoordX[0] = n;
            this.axcoordX[1] = n3;
        } else {
            this.axcoordX[0] = n3;
            this.axcoordX[1] = n;
        }
        if (n2 < n4) {
            this.axcoordY[0] = n2;
            this.axcoordY[1] = n4;
        } else {
            this.axcoordY[0] = n4;
            this.axcoordY[1] = n2;
        }
    }

    private void setAyCoord(int n, int n2, int n3, int n4) {
        if (n < n3) {
            this.aycoordX[0] = n;
            this.aycoordX[1] = n3;
        } else {
            this.aycoordX[0] = n3;
            this.aycoordX[1] = n;
        }
        if (n2 < n4) {
            this.aycoordY[0] = n2;
            this.aycoordY[1] = n4;
        } else {
            this.aycoordY[0] = n4;
            this.aycoordY[1] = n2;
        }
    }

    protected Axis getMouseOverAxis(int n, int n2) {
        if (n >= this.axcoordX[0] - 2 && n <= this.axcoordX[1] + 2 && n2 >= this.axcoordY[0] - 2 && n2 <= this.axcoordY[1] + 2) {
            return this.ax;
        }
        if (n >= this.aycoordX[0] - 2 && n <= this.aycoordX[1] + 2 && n2 >= this.aycoordY[0] - 2 && n2 <= this.aycoordY[1] + 2) {
            return this.ay;
        }
        return null;
    }

    protected String getAxisQuery(int n, int n2) {
        Axis axis = this.getMouseOverAxis(n, n2);
        if (axis == null) {
            return null;
        }
        return "axis name: " + axis.getVariable().getName() + "\nbin width: " + Tools.getDisplayableValue(this.binw, 2) + "\nanchor: " + Tools.getDisplayableValue(this.anchor, 2) + (this.v.hasMissing() ? "\nmissings: " + this.v.getMissingCount() : "");
    }

    public void setIsSpine(boolean bl) {
        this.isSpine = bl;
        if (bl) {
            this.createSpinovar();
            this.normalAx = this.ax;
            this.ax = new Axis(this.spinovar, 0, 2);
            this.MIspine.setLabel("Histogram");
            this.updateGeometry = true;
        } else {
            this.ax = this.normalAx;
            this.MIspine.setLabel("Spinogram");
            this.updateGeometry = true;
        }
    }

    private String getIntervalForBox(int n) {
        double d = this.normalAx.vBegin + this.binw * (double)n;
        return "[" + this.normalAx.getDisplayableValue(d) + ", " + this.normalAx.getDisplayableValue(d + this.binw) + ")";
    }

    private void createSpinovar() {
        int n;
        int[] nArray = new int[this.v.size()];
        String[] stringArray = new String[this.bars];
        for (n = 0; n < this.bars; ++n) {
            PPrimRectangle pPrimRectangle = (PPrimRectangle)this.pp[n];
            if (pPrimRectangle.ref == null) continue;
            for (int i = 0; i < pPrimRectangle.ref.length; ++i) {
                nArray[pPrimRectangle.ref[i]] = n;
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.getIntervalForBox(n);
        }
        this.spinovar = new SVarFact("spinovar" + this.v.getName(), nArray, stringArray);
    }

    public boolean adjustMargin(PoGraSS poGraSS) {
        int n = 0;
        Axis axis = this.orientation == 0 || this.orientation == 2 ? this.ay : this.ax;
        double d = axis.getSensibleTickDistance(this.verticalMedDist, this.verticalMinDist);
        for (double d2 = axis.getSensibleTickStart(d); d2 < axis.vBegin + axis.vLen; d2 += d) {
            String string = axis.getDisplayableValue(d2);
            if (string.length() <= n) continue;
            n = string.length();
        }
        if (this.orientation == 3) {
            int n2 = this.mRight;
            this.mRight = n * 8 > 20 ? n * 8 + 2 : 20;
            if (this.mRight > n2) {
                return true;
            }
            this.mRight = n2;
        } else {
            int n3 = this.mLeft;
            this.mLeft = n * 8 > 20 ? n * 8 + 2 : 20;
            if (this.mLeft > n3) {
                return true;
            }
            this.mLeft = n3;
        }
        return false;
    }
}

