/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Vector;
import org.rosuda.ibase.toolkit.WTentry;
import org.rosuda.util.Global;

public class WinTracker
implements ActionListener,
FocusListener {
    public static WinTracker current = null;
    Vector wins = new Vector();
    WTentry curFocus = null;

    void newWindowMenu(WTentry wTentry) {
        wTentry.addMenuItem("@WClose window", "WTMclose" + wTentry.id);
        wTentry.addMenuItem("!WClose same type", "WTMcloseClass" + wTentry.wclass);
        wTentry.addMenuItem("Close all", "WTMcloseAll");
        wTentry.addMenuSeparator();
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry2 = (WTentry)enumeration.nextElement();
            if (wTentry2 == null || wTentry2 == wTentry) continue;
            wTentry2.addWindowMenuEntry(wTentry);
        }
    }

    public void add(WTentry wTentry) {
        if (wTentry == null) {
            return;
        }
        this.wins.addElement(wTentry);
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry2 = (WTentry)enumeration.nextElement();
            if (Global.DEBUG > 0) {
                System.out.println("-- updating menu; we2=" + wTentry2.toString());
            }
            if (wTentry2 == null) continue;
            wTentry.addWindowMenuEntry(wTentry2);
            if (Global.DEBUG <= 0) continue;
            System.out.println("-- menu updated");
        }
        if (wTentry.w != null) {
            wTentry.w.addFocusListener(this);
        }
        if (Global.DEBUG > 0) {
            System.out.println(">>new window: \"" + wTentry.name + "\" (" + wTentry.w.toString() + ")");
        }
    }

    public boolean contains(int n) {
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry.wclass != n || wTentry.w == null) continue;
            wTentry.w.requestFocus();
            wTentry.w.toFront();
            try {
                Frame frame = (Frame)wTentry.w;
                frame.setState(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void disableAll() {
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            ((WTentry)enumeration.nextElement()).w.setFocusableWindowState(false);
        }
    }

    public void enableAll() {
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            ((WTentry)enumeration.nextElement()).w.setFocusableWindowState(true);
        }
    }

    public void rm(WTentry wTentry) {
        if (wTentry == null) {
            return;
        }
        this.wins.removeElement(wTentry);
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry2 = (WTentry)enumeration.nextElement();
            if (wTentry2 == null) continue;
            wTentry.rmWindowMenuEntry(wTentry2);
        }
        if (Global.DEBUG > 0) {
            System.out.println(">>window removed: \"" + wTentry.name + "\"");
        }
        if (this.wins.size() == 0 && Global.AppType == 0) {
            System.out.println("FATAL: Stand-alone mode, last window closed, but no splash screen present. Assuming exit request.");
            System.exit(0);
        }
    }

    public void rm(Window window) {
        if (Global.DEBUG > 0) {
            System.out.println(">>request to remove window \"" + window.toString() + "\"");
        }
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (Global.DEBUG > 0) {
                System.out.println("-- lookup: " + (wTentry == null ? "<null>" : wTentry.toString()));
            }
            if (wTentry == null || wTentry.w != window) continue;
            if (Global.DEBUG > 0) {
                System.out.println("-- matches");
            }
            this.rm(wTentry);
            return;
        }
    }

    public Object getWindowMenu(Window window) {
        WTentry wTentry = this.getEntry(window);
        System.out.println(wTentry.toString());
        return wTentry == null ? null : wTentry.getWindowMenu();
    }

    public Enumeration elements() {
        return this.wins.elements();
    }

    public WTentry getEntry(int n) {
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry == null || wTentry.id != n) continue;
            return wTentry;
        }
        return null;
    }

    public WTentry getEntry(Window window) {
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry == null || wTentry.w != window) continue;
            return wTentry;
        }
        return null;
    }

    public void disposeAll() {
        if (Global.DEBUG > 0) {
            System.out.println(">>dispose all requested");
        }
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry == null || wTentry.w == null) continue;
            wTentry.w.dispose();
        }
        this.wins.removeAllElements();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (Global.DEBUG > 0) {
            System.out.println(">> action: " + string + " by " + object.toString());
        }
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry != null && (string.compareTo("WTMclose" + wTentry.id) == 0 || "WTMcloseAll".equals(string) && wTentry.wclass > 8 || string.equals("WTMcloseClass" + wTentry.wclass))) {
                if (Global.DEBUG > 0) {
                    System.out.println(">>close:  (" + wTentry.id + ")");
                }
                if (wTentry.w != null) {
                    wTentry.w.dispose();
                }
            }
            if (wTentry == null || string.compareTo("WTMwindow" + wTentry.id) != 0) continue;
            if (Global.DEBUG > 0) {
                System.out.println(">>activate: \"" + wTentry.name + "\" (" + wTentry.w.toString() + ")");
            }
            if (wTentry.w == null) continue;
            wTentry.w.requestFocus();
            wTentry.w.toFront();
            try {
                Frame frame = (Frame)wTentry.w;
                frame.setState(0);
            }
            catch (Exception exception) {}
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Window window = (Window)focusEvent.getSource();
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry == null || wTentry.w != window) continue;
            this.curFocus = wTentry;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Window window = (Window)focusEvent.getSource();
        Enumeration enumeration = this.wins.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry == null || wTentry.w != window || this.curFocus != wTentry) continue;
            this.curFocus = null;
        }
    }

    public void Exit() {
        this.disposeAll();
        System.exit(0);
    }
}

