% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{iris_long}
\alias{iris_long}
\title{Edgar Anderson's Iris Data in long format.}
\format{
A data frame with 600 rows and 5 variables
\itemize{
\item id. Dummy identity number for each flower (150 flowers in total).
\item Species.	The species are \emph{Iris setosa}, \emph{versicolor}, and
\emph{virginica}.
\item condition. Factor giving a detailed description of the attribute
(Four levels: \code{"Petal.Length"}, \code{"Petal.Width"},  \code{"Sepal.Length"},
\code{"Sepal.Width"}).
\item attribute.	What attribute is being measured (\code{"Sepal"} or \code{"Pepal"}).
\item measure.	What aspect of the attribute is being measured (\code{"Length"}
or \code{"Width"}).
\item value.	Value of the measurement.
}
}
\source{
\url{https://stat.ethz.ch/R-manual/R-devel/library/datasets/html/iris.html}
}
\usage{
iris_long
}
\description{
Edgar Anderson's Iris Data in long format.
}
\details{
This famous (Fisher's or Anderson's) iris data set gives the
measurements in centimeters of the variables sepal length and width and
petal length and width, respectively, for 50 flowers from each of 3 species
of iris. The species are Iris setosa, versicolor, and virginica.

This is a modified dataset from \code{datasets} package.
}
\examples{
dim(iris_long)
head(iris_long)
dplyr::glimpse(iris_long)
}
\keyword{datasets}
