% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ipm_report.R
\name{make_ipm_report}
\alias{make_ipm_report}
\alias{make_ipm_report.default}
\alias{make_ipm_report.ipmr_ipm}
\alias{make_ipm_report_body}
\title{Generate an RMarkdown file with IPM metadata}
\usage{
make_ipm_report(
  object,
  rmd_dest = getwd(),
  title = "",
  output_format = "html",
  render_output = FALSE,
  block_eqs = TRUE,
  long_eq_length = 65
)

\method{make_ipm_report}{default}(
  object,
  rmd_dest = getwd(),
  title = "",
  output_format = "html",
  render_output = FALSE,
  block_eqs = TRUE,
  long_eq_length = 65
)

\method{make_ipm_report}{ipmr_ipm}(
  object,
  rmd_dest = getwd(),
  title = "",
  output_format = "html",
  render_output = FALSE,
  block_eqs = TRUE,
  long_eq_length = 65
)

make_ipm_report_body(proto_ipm, block_eqs, rmd_dest, long_eq_length)
}
\arguments{
\item{object}{A \code{proto_ipm} or output from \code{make_ipm()}.}

\item{rmd_dest}{The folder to save the Rmd file at. The default is
\code{getwd()}. Alternatively, can be a complete file path that specifies
the location and title of the document with the extension \code{".rmd"}. in
this case, the current date will be appended to the title.}

\item{title}{The title to include in the document. This is not necessarily
the same as \code{rmd_dest}, as this appears at the top of the generated
report, and is not included in the file path!}

\item{output_format}{The format to include in the YAML header for the created
\code{.rmd} document.}

\item{render_output}{A logical indicating whether to call
\code{rmarkdown::render} on the generated \code{.rmd} file. Often times,
the \code{.rmd} file will need further editing before it's useful, so the
default is \code{FALSE}.}

\item{block_eqs}{A logical. If \code{TRUE}, all equations will be inserted
with blocks and numbered using \code{tag{}}. If \code{FALSE}, equations
will be rendered as inline equations on a single line, and numbered as
1.1, 1.2, 1.3 (iteration expressions), 2.1, 2.2 (vital rate expressions),
etc.}

\item{long_eq_length}{For longer equations, \code{make_ipm_report} tries
to wrap these into multiple lines using \code{\\\\}. This parameter controls
the number of characters per line. Default is 65. Ignored when
\code{block_eqs = FALSE}.}

\item{proto_ipm}{A \code{proto_ipm} object. Only used for
\code{make_ipm_report_body}.}
}
\value{
For \code{make_ipm_report}, the filepath to the \code{.rmd} file. The
  default name is \code{ "ipmr_report_<current_date>.rmd"}. For
  \code{make_ipm_report_body}, a character vector with Markdown and LaTeX
  suitable for rendering, but without a header.
}
\description{
Generates a \code{.rmd} file containing a mathematical
  description of the \code{proto_ipm} object.
}
\details{
\code{make_ipm_report_body} only translates the iteration
  expressions and vital rate expressions into Markdown with LaTeX, and does
  not produce any headers needed to knit the file. This function is exported
  mostly for re-usage in \code{\link[Rpadrino]{pdb_report}}, and isn't really
  intended for use by \code{ipmr} users.
}
\section{\strong{Translations}}{


  For iteration expressions, vital rate expressions, and parameter names,
  \code{make_ipm_report} first translates all values in the \code{data_list}
  to \code{beta_X}. For example, \code{s = surv_int + surv_slope * z_1} is
  translated into \code{beta_0 + beta_1 * z_1}, and then is translated into
  LaTeX equations. Since everything is call \code{beta_X}, a glossary is
  provided at the end of each report that matches \code{beta}s to their names
  in the \code{data_list}.
}

