% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{range_boundaries_to_cidr}
\alias{range_boundaries_to_cidr}
\title{Convert a start+end IP address range pair to representative CIDR blocks}
\usage{
range_boundaries_to_cidr(ip_start, ip_end)
}
\arguments{
\item{ip_start, ip_end}{range start/end (numeric)}
}
\value{
character vector
}
\description{
takes in a single start/end pair and returns a charcter vector
             of all the CIDR blocks necessary to contain the range.
}
\examples{
range_boundaries_to_cidr(
 ip_to_numeric("192.100.176.0"),
 ip_to_numeric("192.100.179.255")
)
## [1] "192.100.176.0/22"
}
