% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddi_read.R
\name{read_nhgis_codebook}
\alias{read_nhgis_codebook}
\title{Read metadata from an NHGIS codebook (.txt) file}
\usage{
read_nhgis_codebook(cb_file, file_select = NULL, raw = FALSE)
}
\arguments{
\item{cb_file}{Path to a codebook (.txt) file, a .zip
archive from an NHGIS extract, or a directory containing the codebook file.}

\item{file_select}{If \code{cb_file} is a .zip archive or directory that contains
multiple codebook files, an expression identifying the file to read.
Accepts a character string specifying the file name, a
\link[=selection_language]{tidyselect selection}, or an index position of the
file. Ignored if \code{cb_file} is the path to a single codebook file.}

\item{raw}{If \code{TRUE}, return a character vector containing the lines
of \code{cb_file} rather than an \code{ipums_ddi} object. Defaults to
\code{FALSE}.}
}
\value{
If \code{raw = FALSE}, an \code{ipums_ddi} object with information on the
variables contained in the data for the extract associated with the given
\code{cb_file}.

If \code{raw = TRUE}, a character vector with one element for each
line of the given \code{cb_file}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Read the variable metadata contained in the .txt codebook file included with
NHGIS extracts into an \link{ipums_ddi} object.

Because NHGIS variable metadata do not
adhere to all the standards of microdata DDI files, some of the \code{ipums_ddi}
fields will not be populated.

This function is marked as experimental while we determine whether
there may be a more robust way to standardize codebook and DDI reading across
IPUMS collections.
}
\examples{
# Example file
nhgis_file <- ipums_example("nhgis0972_csv.zip")

# Read codebook as an `ipums_ddi` object:
codebook <- read_nhgis_codebook(nhgis_file)

# Variable-level metadata about the contents of the data file:
ipums_var_info(codebook)

ipums_var_label(codebook, "PMSA")

# If variable metadata have been lost from a data source, reattach from
# the corresponding `ipums_ddi` object:
nhgis_data <- read_nhgis(nhgis_file, verbose = FALSE)

nhgis_data <- zap_ipums_attributes(nhgis_data)
ipums_var_label(nhgis_data$PMSA)

nhgis_data <- set_ipums_var_attributes(nhgis_data, codebook$var_info)
ipums_var_label(nhgis_data$PMSA)

# You can also load the codebook in raw format to display in the console
codebook_raw <- read_nhgis_codebook(nhgis_file, raw = TRUE)

# Use `cat` for human-readable output
cat(codebook_raw[1:20], sep = "\n")
}
\seealso{
\code{\link[=read_nhgis]{read_nhgis()}} to read tabular data from an IPUMS NHGIS extract.

\code{\link[=read_ipums_sf]{read_ipums_sf()}} to read spatial data from an IPUMS extract.

\code{\link[=ipums_list_files]{ipums_list_files()}} to list files in an IPUMS extract.
}
